/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.frameworklogadapter.internal;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

public class GyrexSlf4jForwarder
implements SynchronousLogListener,
LogFilter {
    private static final int DEFAULT_CAPACITY = 200;
    static final String EQUINOX_LOGGER_NAME = "org.eclipse.equinox.logger";
    static final String NEWLINE = System.getProperty("line.separator");
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicReference<SLF4JLogger> activeLogger = new AtomicReference();
    final BlockingQueue<LogEntry> logBuffer;
    final ExecutorService logDispatcher;
    private final AtomicBoolean capacityWarningPrinted = new AtomicBoolean(false);

    private static void addServiceProperty(ServiceReference sr, String key, StringBuilder serviceInfo) {
        Object value = sr.getProperty(key);
        if (value != null) {
            if (serviceInfo.length() > 0) {
                serviceInfo.append(", ");
            }
            serviceInfo.append(key).append(": ");
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                String separator = "";
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object val = objectArray[n2];
                    serviceInfo.append(separator).append(val);
                    separator = ",";
                    ++n2;
                }
            } else {
                serviceInfo.append(value);
            }
        }
    }

    static String getLevel(LogEntry entry) {
        switch (entry.getLevel()) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
        }
        return "DEBUG";
    }

    static String getMessage(LogEntry entry) {
        ServiceReference sr = entry.getServiceReference();
        if (sr != null) {
            StringBuilder serviceInfo = new StringBuilder(400);
            GyrexSlf4jForwarder.addServiceProperty(sr, "service.pid", serviceInfo);
            GyrexSlf4jForwarder.addServiceProperty(sr, "service.id", serviceInfo);
            GyrexSlf4jForwarder.addServiceProperty(sr, "service.vendor", serviceInfo);
            GyrexSlf4jForwarder.addServiceProperty(sr, "objectClass", serviceInfo);
            return String.format("%s - %s", entry.getMessage(), serviceInfo.toString());
        }
        Bundle bundle = entry.getBundle();
        if (bundle != null && bundle.getBundleId() != 0L) {
            return String.format("%s - %s, id: %d", entry.getMessage(), bundle.getSymbolicName(), bundle.getBundleId());
        }
        return entry.getMessage();
    }

    static PrintStream getStream(LogEntry entry) {
        switch (entry.getLevel()) {
            case 1: {
                return System.err;
            }
            case 4: {
                return EclipseStarter.debug ? System.out : null;
            }
        }
        return System.out;
    }

    public GyrexSlf4jForwarder(int bufferSize, boolean fallbackToSysout) {
        if (!fallbackToSysout) {
            this.logBuffer = new LinkedBlockingQueue<LogEntry>(bufferSize > 0 ? bufferSize : 200);
            this.logDispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "Gyrex FrameworkLog Buffer Dispatcher");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        } else {
            this.logBuffer = null;
            this.logDispatcher = null;
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.shutdown();
        }
    }

    public boolean isLoggable(Bundle bundle, String loggerName, int logLevel) {
        if (loggerName != null && !EQUINOX_LOGGER_NAME.equals(loggerName)) {
            return false;
        }
        switch (logLevel) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return EclipseStarter.debug;
    }

    public void logged(LogEntry entry) {
        if (entry != null && !this.closed.get()) {
            SLF4JLogger logger = this.activeLogger.get();
            if (logger != null) {
                logger.log(entry);
            } else if (this.logBuffer == null) {
                PrintStream stream = GyrexSlf4jForwarder.getStream(entry);
                if (stream != null) {
                    stream.printf("%1$tH:%1$tM:%1$tS.%1$tL [%2$s] %3$-5s %4$s - %5$s%n", new Date(entry.getTime()), Thread.currentThread().getName(), GyrexSlf4jForwarder.getLevel(entry), EQUINOX_LOGGER_NAME, GyrexSlf4jForwarder.getMessage(entry));
                }
            } else if (!this.logBuffer.offer(entry) && EclipseStarter.debug && !this.capacityWarningPrinted.get() && this.capacityWarningPrinted.compareAndSet(false, true)) {
                System.err.printf("[Eclipse Gyrex] Log buffer capacity limit reached. Some framework log messages will be discarded. Try increasing the buffer size (system property '%s') or enable fallback to STDOUT (system property '%s').%n", "gyrex.log.forwarder.buffer.size", "gyrex.log.forwarder.fallback.sysout");
            }
        }
    }

    public void setSLF4JLogger(Object logger) {
        this.activeLogger.set(logger != null ? new SLF4JLogger(logger) : null);
        if (this.logDispatcher != null) {
            this.logDispatcher.execute(new LogBufferFlush());
        }
    }

    private void shutdown() {
        if (this.logDispatcher != null) {
            this.logDispatcher.shutdownNow();
        }
        if (this.logBuffer != null) {
            this.logBuffer.clear();
        }
    }

    final class LogBufferFlush
    implements Runnable {
        LogBufferFlush() {
        }

        @Override
        public void run() {
            while (!GyrexSlf4jForwarder.this.closed.get() && !GyrexSlf4jForwarder.this.logBuffer.isEmpty()) {
                SLF4JLogger logger = GyrexSlf4jForwarder.this.activeLogger.get();
                if (logger == null) {
                    return;
                }
                LogEntry entry = (LogEntry)GyrexSlf4jForwarder.this.logBuffer.poll();
                if (entry == null) {
                    return;
                }
                logger.log(entry);
            }
        }
    }

    static final class SLF4JLogger {
        static final int TRACE_INT = 0;
        static final int DEBUG_INT = 10;
        static final int INFO_INT = 20;
        static final int WARN_INT = 30;
        static final int ERROR_INT = 40;
        private final Object logger;
        private final Method logMethod;

        private static Method findLogMethod(Object logger) {
            Method[] methods;
            Method[] methodArray = methods = logger.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Class<?>[] parameterTypes = method.getParameterTypes();
                if ("log".equals(method.getName()) && parameterTypes.length == 6 && parameterTypes[1].equals(String.class) && parameterTypes[2].equals(Integer.TYPE) && parameterTypes[3].equals(String.class) && parameterTypes[5].equals(Throwable.class)) {
                    return method;
                }
                ++n2;
            }
            return null;
        }

        public SLF4JLogger(Object logger) {
            this.logger = logger;
            this.logMethod = SLF4JLogger.findLogMethod(logger);
        }

        private Object getLevel(LogEntry entry) {
            switch (entry.getLevel()) {
                case 1: {
                    return 40;
                }
                case 2: {
                    return 30;
                }
                case 3: {
                    return 20;
                }
            }
            return 10;
        }

        public void log(LogEntry entry) {
            if (this.logMethod == null) {
                return;
            }
            try {
                this.logMethod.invoke(this.logger, null, "org.eclipse.osgi.framework.log.FrameworkLogEntry", this.getLevel(entry), GyrexSlf4jForwarder.getMessage(entry), null, entry.getException());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

