/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.CleanupJob;
import org.eclipse.gyrex.jobs.internal.manager.IJobStateWatch;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryStore;
import org.eclipse.gyrex.jobs.internal.manager.JobHungDetectionHelper;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerImpl
implements IJobManager {
    private static final long DEFAULT_MODIFY_LOCK_TIMEOUT = 3000L;
    static final String NODE_PARAMETER = "parameter";
    static final String NODE_STATES = "status";
    static final String PROPERTY_TYPE = "type";
    static final String PROPERTY_STATUS = "status";
    static final String PROPERTY_LAST_START = "lastStart";
    static final String PROPERTY_LAST_QUEUED = "lastQueued";
    static final String PROPERTY_LAST_QUEUED_TRIGGER = "lastQueuedTrigger";
    static final String PROPERTY_LAST_CANCELLED = "lastCancelled";
    static final String PROPERTY_LAST_CANCELLED_TRIGGER = "lastCancelledTrigger";
    static final String PROPERTY_LAST_SUCCESSFUL_FINISH = "lastSuccessfulFinish";
    static final String PROPERTY_LAST_RESULT_MESSAGE = "lastResultMessage";
    static final String PROPERTY_LAST_RESULT_SEVERITY = "lastResultSeverity";
    static final String PROPERTY_LAST_RESULT = "lastResultTimestamp";
    static final String PROPERTY_ACTIVE = "active";
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerImpl.class);
    private static AtomicLong lastCleanup = new AtomicLong();
    private static final long modifyLockTimeout = Long.getLong("gyrex.jobs.modifyLock.timeout", 3000L);
    static final String SEPARATOR = "_";
    private final IRuntimeContext context;
    private final String internalIdPrefix;

    static IExclusiveLock acquireLock(JobImpl job) {
        String lockId = "gyrex.jobs.modify.".concat(job.getStorageKey());
        if (JobsDebug.jobLocks) {
            LOG.debug("Requesting lock {} for job {}", new Object[]{lockId, job.getId(), new Exception("Call Stack")});
        }
        try {
            return ((ILockService)JobsActivator.getInstance().getService(ILockService.class)).acquireExclusiveLock(lockId, null, modifyLockTimeout);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to get job modify lock. %s", e.getMessage()), e);
        }
    }

    public static void cancel(JobImpl job, String trigger) {
        IExclusiveLock jobLock = null;
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            job = JobManagerImpl.getJob(job.getId(), job.getStorageKey());
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", job.getId()));
            }
            if (job.getState() != JobState.WAITING && job.getState() != JobState.RUNNING) {
                return;
            }
            try {
                JobManagerImpl.setJobState(job, JobState.ABORTING, jobLock);
                JobManagerImpl.setJobCancelled(job, System.currentTimeMillis(), trigger != null ? trigger : JobManagerImpl.findCaller(), jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error canceling job %s. %s", job.getId(), e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, job.getId());
        }
    }

    private static String findCaller() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length == 0) {
            return "";
        }
        int i = 0;
        while (i < trace.length) {
            if (!StringUtils.startsWith((String)trace[i].getClassName(), (String)JobManagerImpl.class.getName())) {
                return trace.toString();
            }
            ++i;
        }
        return "";
    }

    public static String getExternalId(String internalId) {
        int i = internalId.indexOf(SEPARATOR);
        if (i < 0) {
            return internalId;
        }
        return internalId.substring(i + 1);
    }

    private static String getInternalIdPrefix(IRuntimeContext context) {
        try {
            return String.valueOf(DigestUtils.shaHex((byte[])context.getContextPath().toString().getBytes("UTF-8"))) + SEPARATOR;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Please use a JVM that supports UTF-8.");
        }
    }

    public static JobImpl getJob(String jobId, String storageKey) throws IllegalStateException {
        block3: {
            try {
                if (JobHistoryStore.getJobsNode().nodeExists(storageKey)) break block3;
                return null;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
            }
        }
        return JobManagerImpl.readJob(jobId, JobHistoryStore.getJobsNode().node(storageKey));
    }

    public static JobImpl readJob(String jobId, Preferences node) throws BackingStoreException {
        JobImpl job = new JobImpl(node.name());
        job.setId(jobId);
        job.setTypeId(node.get(PROPERTY_TYPE, null));
        job.setStatus(JobManagerImpl.toState(node.get("status", null)));
        job.setActive(node.getBoolean(PROPERTY_ACTIVE, false));
        job.setLastStart(node.getLong(PROPERTY_LAST_START, -1L));
        job.setLastSuccessfulFinish(node.getLong(PROPERTY_LAST_SUCCESSFUL_FINISH, -1L));
        long lastResultTimestamp = node.getLong(PROPERTY_LAST_RESULT, -1L);
        if (lastResultTimestamp > -1L) {
            job.setLastResult(lastResultTimestamp, node.getInt(PROPERTY_LAST_RESULT_SEVERITY, 8), node.get(PROPERTY_LAST_RESULT_MESSAGE, ""));
        }
        job.setLastQueued(node.getLong(PROPERTY_LAST_QUEUED, -1L));
        job.setLastQueuedTrigger(node.get(PROPERTY_LAST_QUEUED_TRIGGER, null));
        job.setLastCancelled(node.getLong(PROPERTY_LAST_CANCELLED, -1L));
        job.setLastCancelledTrigger(node.get(PROPERTY_LAST_CANCELLED_TRIGGER, null));
        HashMap<String, String> jobParamater = JobManagerImpl.readParameter(node);
        job.setParameter(jobParamater);
        return job;
    }

    static HashMap<String, String> readParameter(Preferences node) throws BackingStoreException {
        if (!node.nodeExists(NODE_PARAMETER)) {
            return null;
        }
        Preferences paramNode = node.node(NODE_PARAMETER);
        String[] keys = paramNode.keys();
        HashMap<String, String> jobParamater = new HashMap<String, String>(keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            jobParamater.put(key, paramNode.get(key, null));
            ++n2;
        }
        return jobParamater;
    }

    private static void releaseLock(IExclusiveLock jobLock, String jobId) {
        if (jobLock != null) {
            if (JobsDebug.jobLocks) {
                LOG.debug("Releasing lock {} for job {}", new Object[]{jobLock.getId(), jobId});
            }
            try {
                jobLock.release();
            }
            catch (Exception exception) {}
        }
    }

    private static void setJobCancelled(JobImpl job, long timestamp, String trigger, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        if (!JobHistoryStore.getJobsNode().nodeExists(job.getStorageKey())) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(job.getStorageKey());
        jobNode.putLong(PROPERTY_LAST_CANCELLED, timestamp);
        jobNode.put(PROPERTY_LAST_CANCELLED_TRIGGER, trigger);
        jobNode.flush();
    }

    private static void setJobState(JobImpl job, JobState state, IExclusiveLock lock) throws BackingStoreException {
        if (state == null) {
            throw new IllegalArgumentException("job state must not be null");
        }
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job state of job %s to %s due to missing or lost job lock!", job.getId(), state.toString()));
        }
        if (!JobHistoryStore.getJobsNode().nodeExists(job.getStorageKey())) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(job.getStorageKey());
        if (StringUtils.equals((String)jobNode.get("status", null), (String)state.name())) {
            return;
        }
        jobNode.put("status", state.name());
        jobNode.flush();
        job.setStatus(state);
    }

    static JobState toState(Object value) {
        if (value instanceof String) {
            try {
                return Enum.valueOf(JobState.class, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return JobState.NONE;
            }
        }
        return JobState.NONE;
    }

    static void triggerCleanUp() {
        long last = lastCleanup.get();
        if (System.currentTimeMillis() - last > TimeUnit.HOURS.toMillis(3L) && lastCleanup.compareAndSet(last, System.currentTimeMillis())) {
            new CleanupJob().schedule();
        }
    }

    @Inject
    public JobManagerImpl(IRuntimeContext context) {
        this.context = context;
        this.internalIdPrefix = JobManagerImpl.getInternalIdPrefix(context);
    }

    @Override
    public void cancelJob(String jobId, String trigger) throws IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.WAITING && job.getState() != JobState.RUNNING) {
            return;
        }
        JobManagerImpl.cancel(job, trigger);
    }

    @Override
    public JobImpl createJob(String jobTypeId, String jobId, Map<String, String> parameter) {
        JobImpl jobImpl;
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException(String.format("Invalid type id '%s'", jobTypeId));
        }
        IExclusiveLock jobLock = null;
        try {
            String internalId = this.toInternalId(jobId);
            if (JobHistoryStore.getJobsNode().nodeExists(internalId)) {
                throw new IllegalStateException(String.format("Job '%s' is already stored", jobId));
            }
            Preferences node = JobHistoryStore.getJobsNode().node(internalId);
            node.put(PROPERTY_TYPE, jobTypeId);
            node.flush();
            JobImpl job = JobManagerImpl.readJob(jobId, node);
            jobLock = JobManagerImpl.acquireLock(job);
            this.setJobParameter(job, parameter, jobLock);
            JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
            jobImpl = JobManagerImpl.readJob(jobId, node);
        }
        catch (BackingStoreException e) {
            try {
                throw new IllegalStateException(String.format("Error creating job data. %s", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                JobManagerImpl.releaseLock(jobLock, jobId);
                throw throwable;
            }
        }
        JobManagerImpl.releaseLock(jobLock, jobId);
        return jobImpl;
    }

    private void doQueueJob(String jobId, Map<String, String> parameter, String queueId, String trigger) {
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.NONE && !this.isStuck(job)) {
            throw new IllegalStateException(String.format("Job %s cannot be queued because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IQueue queue = JobsActivator.getInstance().getQueueService().getQueue(queueId != null ? queueId : "gyrex.jobs.queue.default", null);
        if (queue == null) {
            throw new IllegalStateException(String.format("Queue %s does not exist!", queueId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (job.getState() != JobState.NONE) {
                if (!this.isStuck(job)) {
                    throw new IllegalStateException(String.format("Job %s cannot be queued because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
                }
                LOG.warn("Job {} is in state {}. However, it's assumed stuck. The queue request will reset the state!", (Object)job.getId(), (Object)job.getState());
            }
            try {
                if (parameter != null) {
                    this.setJobParameter(job, parameter, jobLock);
                }
                JobManagerImpl.setJobState(job, JobState.WAITING, jobLock);
                queue.sendMessage(JobInfo.asMessage(new JobInfo(job.getTypeId(), jobId, this.context.getContextPath(), job.getParameter())));
                try {
                    this.setJobQueued(job, System.currentTimeMillis(), trigger != null ? trigger : JobManagerImpl.findCaller(), jobLock);
                }
                catch (Exception e) {
                    LOG.warn("Unable to set job queue time for job {}: {}", (Object)jobId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            catch (Exception e) {
                try {
                    JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
                }
                catch (Exception exception) {
                    LOG.error("Unable to reset job state for job {}: {}", (Object)jobId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                throw new IllegalStateException(String.format("Error queuing job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
        JobManagerImpl.triggerCleanUp();
    }

    @Override
    public JobHistoryImpl getHistory(String jobId) throws IllegalStateException {
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job '%s' does not exist.", jobId));
        }
        try {
            return JobHistoryStore.create(this.toInternalId(jobId), jobId, this.context);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading history", e);
        }
    }

    @Override
    public JobImpl getJob(String jobId) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        return JobManagerImpl.getJob(jobId, this.toInternalId(jobId));
    }

    @Override
    public Collection<String> getJobs() {
        try {
            String[] storageIds = JobHistoryStore.getJobsNode().childrenNames();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (internalId.startsWith(this.internalIdPrefix)) {
                    jobIds.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    @Override
    public Collection<String> getJobsByState(JobState state) {
        if (state == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        try {
            String[] storageIds = JobHistoryStore.getJobsNode().childrenNames();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (internalId.startsWith(this.internalIdPrefix) && StringUtils.equals((String)JobHistoryStore.getJobsNode().node(internalId).get("status", null), (String)state.name())) {
                    jobIds.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    public boolean isStuck(JobImpl job) {
        return JobHungDetectionHelper.isStuck(this.toInternalId(job.getId()), job, false);
    }

    @Override
    public void queueJob(String jobId, Map<String, String> parameter, String queueId, String trigger) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        this.doQueueJob(jobId, parameter, queueId, trigger);
    }

    @Override
    public void queueJob(String jobId, String queueId, String trigger) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        this.doQueueJob(jobId, null, queueId, trigger);
    }

    @Override
    public void removeJob(String jobId) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job.getState() != JobState.NONE) {
            throw new IllegalStateException(String.format("Job %s cannot be removed because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IExclusiveLock jobLock = null;
        try {
            try {
                jobLock = JobManagerImpl.acquireLock(job);
                String internalId = this.toInternalId(jobId);
                IEclipsePreferences jobsNode = JobHistoryStore.getJobsNode();
                if (jobsNode.nodeExists(internalId)) {
                    jobsNode.node(internalId).removeNode();
                    jobsNode.flush();
                }
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error removing job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    public void setActive(String jobId) throws Exception {
        if (JobsDebug.debug) {
            LOG.debug("Marking job {} active.", (Object)jobId);
        }
        JobHungDetectionHelper.setActive(this.toInternalId(jobId));
        Preferences jobNode = JobHistoryStore.getJobsNode().node(this.toInternalId(jobId));
        jobNode.sync();
        jobNode.putBoolean(PROPERTY_ACTIVE, true);
        jobNode.flush();
    }

    public void setInactive(String jobId) throws Exception {
        if (JobsDebug.debug) {
            LOG.debug("Marking job {} inactive.", (Object)jobId);
        }
        JobHungDetectionHelper.setInactive(this.toInternalId(jobId));
        Preferences jobNode = JobHistoryStore.getJobsNode().node(this.toInternalId(jobId));
        jobNode.sync();
        jobNode.remove(PROPERTY_ACTIVE);
        jobNode.flush();
    }

    private void setJobParameter(JobImpl job, Map<String, String> parameter, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update parameter of job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        if (parameter != null && !parameter.isEmpty()) {
            Preferences paramNode = jobNode.node(NODE_PARAMETER);
            String[] stringArray = paramNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (StringUtils.isBlank((String)parameter.get(key))) {
                    paramNode.remove(key);
                }
                ++n2;
            }
            for (Map.Entry<String, String> entry : parameter.entrySet()) {
                if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
                paramNode.put(entry.getKey(), entry.getValue());
            }
        } else if (jobNode.nodeExists(NODE_PARAMETER)) {
            jobNode.node(NODE_PARAMETER).removeNode();
        }
        jobNode.flush();
        job.setParameter(new HashMap<String, String>(parameter));
    }

    @Override
    public void setJobParameter(String jobId, Map<String, String> parameter) throws IllegalStateException, IllegalArgumentException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.NONE && !this.isStuck(job)) {
            throw new IllegalStateException(String.format("Job %s cannot be updated because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IExclusiveLock jobLock = null;
        try {
            try {
                jobLock = JobManagerImpl.acquireLock(job);
                job = this.getJob(jobId);
                if (job == null) {
                    throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
                }
                if (job.getState() != JobState.NONE) {
                    if (!this.isStuck(job)) {
                        throw new IllegalStateException(String.format("Job %s cannot be updated because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
                    }
                    LOG.warn("Job {} is in state {}. However, it's assumed stuck. The updated will reset the state!", (Object)job.getId(), (Object)job.getState());
                }
                this.setJobParameter(job, parameter, jobLock);
                JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error updating job parameter. %s", e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    private void setJobQueued(IJob job, long timestamp, String trigger, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        jobNode.putLong(PROPERTY_LAST_QUEUED, timestamp);
        jobNode.put(PROPERTY_LAST_QUEUED_TRIGGER, trigger);
        jobNode.flush();
    }

    private void setJobResult(JobImpl job, Map<String, String> parameter, IStatus result, long resultTimestamp, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job result of job %s due to missing or lost job lock!", job.getId()));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Unable to update job result of job %s due to missing result!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        jobNode.putLong(PROPERTY_LAST_RESULT, resultTimestamp);
        jobNode.put(PROPERTY_LAST_RESULT_MESSAGE, JobHistoryImpl.getFormattedMessage(result, 0));
        jobNode.putInt(PROPERTY_LAST_RESULT_SEVERITY, result.getSeverity());
        if (!result.matches(12)) {
            jobNode.putLong(PROPERTY_LAST_SUCCESSFUL_FINISH, resultTimestamp);
        }
        jobNode.flush();
        JobHistoryImpl history = JobHistoryStore.create(internalId, job.getId(), this.context);
        history.createEntry(resultTimestamp, result, job.getLastQueued(), job.getLastQueuedTrigger(), job.getLastCancelled(), job.getLastCancelledTrigger(), parameter);
        JobHistoryStore.flush(internalId, history);
    }

    private void setJobStartTime(IJob job, long startTimestamp, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!JobHistoryStore.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = JobHistoryStore.getJobsNode().node(internalId);
        jobNode.putLong(PROPERTY_LAST_START, startTimestamp);
        jobNode.flush();
    }

    public boolean setJobState(String jobId, JobState expected, JobState state, IJobStateWatch stateWatch) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (state == null) {
            throw new IllegalArgumentException("Job state must not be null");
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (expected != null && job.getState() != expected) {
                if (!this.isStuck(job)) {
                    return false;
                }
                LOG.warn("Job {} is in state {} which doesn't match the expected state {}. However, it's assumed stuck. Thus, the status will be reset to {}!", new Object[]{job.getId(), job.getState(), expected, state});
            }
            try {
                JobManagerImpl.setJobState(job, state, jobLock);
                if (state == JobState.RUNNING) {
                    this.setJobStartTime(job, System.currentTimeMillis(), jobLock);
                }
                if (stateWatch != null) {
                    ((IEclipsePreferences)JobHistoryStore.getJobsNode().node(this.toInternalId(jobId))).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new StateWatchListener(jobId, state, stateWatch));
                }
                return true;
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error updating state of job %s to %s. %s", jobId, state.name(), e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    public void setResult(String jobId, Map<String, String> parameter, IStatus result, long resultTimestamp) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            try {
                JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
                this.setJobResult(job, parameter, result, resultTimestamp, jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error setting result of job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    private void syncJobNode(String jobId) {
        try {
            JobHistoryStore.getJobsNode().node(this.toInternalId(jobId)).sync();
        }
        catch (BackingStoreException e) {
            LOG.warn("Exception refreshing job {}. Available job data might be stale.", (Object)this.toInternalId(jobId), (Object)e);
        }
    }

    private String toExternalId(String internalId) {
        return StringUtils.removeStart((String)internalId, (String)this.internalIdPrefix);
    }

    private String toInternalId(String id) {
        return this.internalIdPrefix.concat(id);
    }

    private static class StateWatchListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final String jobId;
        private final JobState state;
        private final IJobStateWatch stateWatch;

        public StateWatchListener(String jobId, JobState state, IJobStateWatch stateWatch) {
            this.jobId = jobId;
            this.state = state;
            this.stateWatch = stateWatch;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"status".equals(event.getKey())) {
                return;
            }
            JobState newState = JobManagerImpl.toState(event.getNewValue());
            if (newState != this.state) {
                try {
                    this.stateWatch.jobStateChanged(this.jobId);
                }
                finally {
                    ((IEclipsePreferences)event.getNode()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                }
            }
        }
    }
}

