/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.services;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.internal.services.ServiceProxyPool;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;

public final class BundleServiceHelper {
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    private final String symbolicName;
    private final ServiceProxyPool serviceProxyPool;

    public BundleServiceHelper(BundleContext context) {
        this.contextRef.set(context);
        this.symbolicName = context.getBundle().getSymbolicName();
        this.serviceProxyPool = new ServiceProxyPool(context);
    }

    public void dispose() {
        this.contextRef.set(null);
        this.serviceProxyPool.dispose();
    }

    private IllegalStateException newInactiveException() {
        return new IllegalStateException(String.format("Bundle '%s' is inactive.", this.symbolicName));
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, String vendor, String description, String pid, Integer ranking) {
        BundleContext bundleContext = this.contextRef.get();
        if (bundleContext == null) {
            throw this.newInactiveException();
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(4);
        if (pid != null) {
            ((Dictionary)properties).put("service.pid", pid);
        }
        if (vendor != null) {
            ((Dictionary)properties).put("service.vendor", vendor);
        }
        if (description != null) {
            ((Dictionary)properties).put("service.description", description);
        }
        if (ranking != null) {
            ((Dictionary)properties).put("service.ranking", ranking);
        }
        return bundleContext.registerService(clazz, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, String vendor, String description, String pid, Integer ranking) {
        BundleContext bundleContext = this.contextRef.get();
        if (bundleContext == null) {
            throw this.newInactiveException();
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(4);
        if (pid != null) {
            ((Dictionary)properties).put("service.pid", pid);
        }
        if (vendor != null) {
            ((Dictionary)properties).put("service.vendor", vendor);
        }
        if (description != null) {
            ((Dictionary)properties).put("service.description", description);
        }
        if (ranking != null) {
            ((Dictionary)properties).put("service.ranking", ranking);
        }
        return bundleContext.registerService(clazz, service, properties);
    }

    public ServiceRegistration registerService(String[] classes, Object service, String vendor, String description, String pid, Integer ranking) {
        BundleContext bundleContext = this.contextRef.get();
        if (bundleContext == null) {
            throw this.newInactiveException();
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(4);
        if (pid != null) {
            ((Dictionary)properties).put("service.pid", pid);
        }
        if (vendor != null) {
            ((Dictionary)properties).put("service.vendor", vendor);
        }
        if (description != null) {
            ((Dictionary)properties).put("service.description", description);
        }
        if (ranking != null) {
            ((Dictionary)properties).put("service.ranking", ranking);
        }
        return bundleContext.registerService(classes, service, properties);
    }

    public <T> IServiceProxy<T> trackService(Class<T> serviceInterface) {
        BundleContext bundleContext = this.contextRef.get();
        if (bundleContext == null) {
            throw this.newInactiveException();
        }
        return this.serviceProxyPool.getOrCreate(serviceInterface);
    }

    public <T> IServiceProxy<T> trackService(Class<T> serviceInterface, Filter filter) {
        if (filter == null) {
            return this.trackService(serviceInterface);
        }
        ServiceProxy.verifyFilterContainsServiceInterfaceCondition(serviceInterface, filter);
        BundleContext bundleContext = this.contextRef.get();
        if (bundleContext == null) {
            throw this.newInactiveException();
        }
        return this.serviceProxyPool.getOrCreate(serviceInterface, filter);
    }
}

