/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.storage.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryContentTypeAssignments {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryContentTypeAssignments.class);
    private final String repositoryId;
    private final Map<String, Set<String>> assignments = new HashMap<String, Set<String>>(3);

    RepositoryContentTypeAssignments(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    void add(String contextPath, String mediaTypeType, String mediaTypeSubtype) {
        if (!this.assignments.containsKey(contextPath)) {
            this.assignments.put(contextPath, new HashSet(2));
        }
        this.assignments.get(contextPath).add(String.format("%s/%s", mediaTypeType, mediaTypeSubtype));
    }

    public Collection<RepositoryContentType> getContentTypes(boolean failIfMissing) throws IllegalStateException {
        HashSet<String> unresolvedContentTypes = new HashSet<String>(1);
        ArrayList<RepositoryContentType> contentTypes = new ArrayList<RepositoryContentType>();
        for (Set<String> mediaTypesSet : this.assignments.values()) {
            for (String assignedMediaType : mediaTypesSet) {
                Collection<RepositoryContentType> types = this.getContentTypes(assignedMediaType);
                if (types.isEmpty()) {
                    unresolvedContentTypes.add(assignedMediaType);
                    continue;
                }
                for (RepositoryContentType contentType : types) {
                    if (contentTypes.contains((Object)contentType)) continue;
                    contentTypes.add(contentType);
                }
            }
        }
        if (!unresolvedContentTypes.isEmpty()) {
            String unresolvedTypesString = StringUtils.join(unresolvedContentTypes, (String)", ");
            if (failIfMissing) {
                throw new IllegalStateException(String.format("Unable to resolve content types assigned to repository '%s': %s", this.repositoryId, unresolvedTypesString));
            }
            LOG.warn("Unable to resolve content types assigned to repository '{}': {}", (Object)this.repositoryId, (Object)unresolvedTypesString);
        }
        return contentTypes;
    }

    private Collection<RepositoryContentType> getContentTypes(String mediaType) {
        return PersistenceActivator.getInstance().getContentTypeTracker().getContentTypes(mediaType);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }
}

