/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.app;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.LogManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator {
    private static File logConfigurationFile;

    public static void configureDefaultContext() throws Exception {
        File configurationFile;
        LogManager.getLogManager().reset();
        if (StringUtils.isNotBlank((String)System.getProperty("logback.configurationFile"))) {
            return;
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        if (lc.getStatusManager() == null) {
            lc.setStatusManager((StatusManager)new BasicStatusManager());
        }
        StatusManager sm = lc.getStatusManager();
        if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
            OnConsoleStatusListener onConsoleStatusListener = new OnConsoleStatusListener();
            onConsoleStatusListener.setContext((Context)lc);
            sm.add((StatusListener)onConsoleStatusListener);
            onConsoleStatusListener.start();
        }
        sm.add((Status)new InfoStatus("Setting up Gyrex log configuration.", (Object)lc));
        final IPath instanceLogfileDirectory = LogbackConfigurator.getLogfileDir();
        if (instanceLogfileDirectory != null) {
            instanceLogfileDirectory.toFile().mkdirs();
        }
        if ((configurationFile = LogbackConfigurator.getLogConfigurationFile()) != null && configurationFile.isFile() && configurationFile.canRead()) {
            sm.add((Status)new InfoStatus(String.format("Loading configuration from '%s'.", configurationFile.getAbsolutePath()), (Object)lc));
            JoranConfigurator configurator = new JoranConfigurator(){

                protected void addImplicitRules(Interpreter interpreter) {
                    super.addImplicitRules(interpreter);
                    if (instanceLogfileDirectory != null) {
                        interpreter.getInterpretationContext().addSubstitutionProperty("gyrex.instance.area.logs", instanceLogfileDirectory.addTrailingSeparator().toOSString());
                    }
                }
            };
            configurator.setContext((Context)lc);
            configurator.doConfigure(configurationFile);
            StatusPrinter.printIfErrorsOccured((Context)lc);
            return;
        }
        Logger rootLogger = lc.getLogger("ROOT");
        LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
        levelChangePropagator.setResetJUL(true);
        levelChangePropagator.setContext((Context)lc);
        lc.addListener((LoggerContextListener)levelChangePropagator);
        levelChangePropagator.start();
        rootLogger.addAppender(LogbackConfigurator.createConsoleAppender(lc));
        if (instanceLogfileDirectory != null) {
            rootLogger.addAppender(LogbackConfigurator.createErrorLogAppender(lc, instanceLogfileDirectory));
        }
        if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
            rootLogger.setLevel(Level.DEBUG);
        } else {
            rootLogger.setLevel(Level.INFO);
        }
        lc.getLogger("org.apache.commons.httpclient").setLevel(Level.WARN);
        lc.getLogger("httpclient.wire").setLevel(Level.WARN);
        lc.getLogger("org.apache.http").setLevel(Level.WARN);
        lc.getLogger("org.apache.zookeeper").setLevel(Level.WARN);
        lc.getLogger("org.apache.solr").setLevel(Level.WARN);
        lc.getLogger("org.mortbay.log").setLevel(Level.INFO);
        lc.getLogger("org.eclipse.jetty").setLevel(Level.INFO);
        lc.getLogger("org.quartz").setLevel(Level.INFO);
        StatusPrinter.printIfErrorsOccured((Context)lc);
    }

    private static ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext lc) {
        ConsoleAppender ca = new ConsoleAppender();
        ca.setContext((Context)lc);
        ca.setName("console");
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext((Context)lc);
        pl.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        pl.start();
        ca.setEncoder((Encoder)pl);
        ca.start();
        return ca;
    }

    private static RollingFileAppender<ILoggingEvent> createErrorLogAppender(LoggerContext lc, IPath instanceLogfileDirectory) {
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setContext((Context)lc);
        rfa.setName("error-log");
        rfa.setFile(instanceLogfileDirectory.append("error.log").toOSString());
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(3);
        rollingPolicy.setFileNamePattern("error.%i.log.zip");
        rollingPolicy.setParent((FileAppender)rfa);
        rfa.setRollingPolicy((RollingPolicy)rollingPolicy);
        rfa.setTriggeringPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy("5MB"));
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext((Context)lc);
        pl.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        pl.setCharset(Charset.forName("UTF-8"));
        pl.start();
        rfa.setEncoder((Encoder)pl);
        ThresholdFilter tf = new ThresholdFilter();
        tf.setContext((Context)lc);
        tf.setLevel(Level.ERROR.toString());
        tf.start();
        rfa.addFilter((Filter)tf);
        rfa.start();
        return rfa;
    }

    private static File getLogConfigurationFile() {
        File file = logConfigurationFile;
        if (file != null) {
            return file;
        }
        Location instanceLocation = BootActivator.getInstance().getInstanceLocation();
        return new Path(instanceLocation.getURL().getPath()).append("etc/logback.xml").toFile();
    }

    private static IPath getLogfileDir() {
        try {
            Location instanceLocation = BootActivator.getInstance().getInstanceLocation();
            return new Path(instanceLocation.getURL().getPath()).append("logs");
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public static void reset() throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        StatusPrinter.printIfErrorsOccured((Context)lc);
    }

    public static File setLogConfigurationFile(File file) {
        File oldFile = logConfigurationFile;
        logConfigurationFile = file;
        return oldFile;
    }
}

