/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsConfigurationPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsLabelProvider;
import org.eclipse.gyrex.admin.ui.jobs.internal.RunningJob;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.jobs.internal.manager.JobHungDetectionHelper;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class RunningJobsSection
extends ViewerWithButtonsSectionPart {
    private Button cancelButton;
    private ListViewer dataList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedValue;
    Display display = PlatformUI.getWorkbench().getDisplay();
    private final ZooKeeperMonitor monitor = new ZooKeeperMonitor(){

        public void process(WatchedEvent event) {
            RunningJobsSection.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RunningJobsSection.this.markStale();
                }
            });
        }
    };

    public RunningJobsSection(Composite parent, JobsConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 512);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Running");
        section.setDescription("Currently running jobs.");
        this.createContent(section);
    }

    void cancelButtonPressed() {
        RunningJob job = this.getSelectedValue();
        if (job == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Cancel Jobe", (String)String.format("Do you really want to cancel job '%s'?", job.id))) {
            return;
        }
        JobImpl jobImpl = JobManagerImpl.getJob((String)job.id, (String)job.storageKey);
        JobManagerImpl.cancel((JobImpl)jobImpl, (String)"Cancelled manually from Gyrex Admin");
        job.aborting = true;
        this.markStale();
    }

    protected void createButtons(Composite buttonsPanel) {
        this.cancelButton = this.createButton(buttonsPanel, "Cancel...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunningJobsSection.this.cancelButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.dataList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        org.eclipse.swt.widgets.List list = this.dataList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.dataList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataList.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.dataList);
        this.setDataInput();
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private RunningJob getSelectedValue() {
        Object value;
        Object object = value = this.selectedValue != null ? this.selectedValue.getValue() : null;
        if (value instanceof RunningJob) {
            return (RunningJob)value;
        }
        return null;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.cancelButton), (IObservableValue)SWTObservables.observeSelection((Control)this.dataList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        this.setDataInput();
        super.refresh();
    }

    private void setDataInput() {
        try {
            ArrayList<RunningJob> input = new ArrayList<RunningJob>();
            List storageKeys = JobHungDetectionHelper.getActiveJobs((ZooKeeperMonitor)this.monitor);
            for (String storageKey : storageKeys) {
                Stat stat = new Stat();
                String nodeId = JobHungDetectionHelper.getProcessingNodeId((String)storageKey, (Stat)stat);
                String id = JobManagerImpl.getExternalId((String)storageKey);
                input.add(new RunningJob(storageKey, id, nodeId, stat));
            }
            this.dataList.setInput(input);
        }
        catch (IllegalStateException e) {
            this.dataList.setInput(Arrays.asList(ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }
}

