/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.Servlet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.http.servlet.HttpServiceServlet;
import org.eclipse.gyrex.admin.ui.internal.AdminUiHttpServiceTracker;
import org.eclipse.gyrex.admin.ui.internal.SimpleAdminLoginService;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUiActivator
extends BaseBundleActivator {
    protected static final String ADMIN_DEFAULT_ROLE = "admin";
    public static final String ADMIN_ALIAS = "admin";
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.admin.ui";
    private static final int DEFAULT_ADMIN_PORT = 3110;
    public static final String TYPE_ADMIN = "org.eclipse.gyrex.admin.ui.http";
    private static final Logger LOG = LoggerFactory.getLogger(AdminUiActivator.class);
    private static volatile AdminUiActivator instance;
    private static volatile Server server;
    public static final String ID_TABBED_PROPERTIES_CONFIG = "org.eclipse.gyrex.admin.ui.content.properties";
    protected static final String PROPERTY_ADMIN_SECURE = "gyrex.admin.secure";
    protected static final String PROPERTY_ADMIN_AUTH = "gyrex.admin.auth";
    private AdminUiHttpServiceTracker adminUiHttpServiceTracker;

    public static ImageDescriptor getImageDescriptor(String path) {
        URL entry = instance.getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)entry);
        return descriptor;
    }

    public static AdminUiActivator getInstance() {
        AdminUiActivator activator = instance;
        if (activator == null) {
            throw new IllegalStateException("inactive");
        }
        return activator;
    }

    public AdminUiActivator() {
        super(SYMBOLIC_NAME);
    }

    private void addNonSslConnector(Server server) {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(3110);
        connector.setMaxIdleTime(30000);
        connector.setLowResourcesConnections(20000);
        connector.setLowResourcesMaxIdleTime(5000);
        connector.setForwarded(true);
        server.addConnector((Connector)connector);
    }

    private void addSslConnector(Server server) {
        try {
            File keystoreFile = Platform.getStateLocation((Bundle)AdminUiActivator.getInstance().getBundle()).append("jettycerts").toFile();
            if (!keystoreFile.isFile()) {
                if (!keystoreFile.getParentFile().isDirectory() && !keystoreFile.getParentFile().mkdirs()) {
                    throw new IllegalStateException("Error creating directory for jetty ssl certificates");
                }
                InputStream stream = this.getBundle().getEntry("cert/jettycerts.jks").openStream();
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)keystoreFile);
                IOUtils.closeQuietly((InputStream)stream);
            }
            SslContextFactory sslContextFactory = new SslContextFactory(keystoreFile.getCanonicalPath());
            sslContextFactory.setKeyStorePassword("changeit");
            sslContextFactory.setKeyManagerPassword("changeit");
            SslSelectChannelConnector connector = new SslSelectChannelConnector(sslContextFactory);
            connector.setPort(3110);
            connector.setMaxIdleTime(30000);
            connector.setLowResourcesConnections(20000);
            connector.setLowResourcesMaxIdleTime(5000);
            connector.setForwarded(true);
            connector.setConfidentialPort(3110);
            connector.setConfidentialScheme("https");
            connector.setIntegralPort(3110);
            connector.setIntegralScheme("https");
            server.addConnector((Connector)connector);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error configuring jetty ssl connector for admin ui.", e);
        }
    }

    private SecurityHandler createSecurityHandler(Handler baseHandler, String username, String password) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        ConstraintMapping authenticationContraintMapping = new ConstraintMapping();
        Constraint constraint = new Constraint("BASIC", "admin");
        constraint.setAuthenticate(true);
        authenticationContraintMapping.setConstraint(constraint);
        authenticationContraintMapping.setPathSpec("/*");
        securityHandler.addConstraintMapping(authenticationContraintMapping);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setHandler(baseHandler);
        securityHandler.setLoginService((LoginService)new SimpleAdminLoginService(username, password));
        return securityHandler;
    }

    protected void doStart(BundleContext context) throws Exception {
        instance = this;
        this.adminUiHttpServiceTracker = new AdminUiHttpServiceTracker(context);
        this.adminUiHttpServiceTracker.open();
        new Job("Start Jetty Admin Server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AdminUiActivator.this.startServer();
                }
                catch (Exception e) {
                    LOG.error("Failed to start Jetty Admin server.", (Throwable)e);
                    ServerApplication.shutdown((Throwable)new IllegalStateException("Unable to start Jetty admin server.", e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule(100L);
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
        this.stopServer();
        this.adminUiHttpServiceTracker.close();
        this.adminUiHttpServiceTracker = null;
    }

    private void startServer() {
        try {
            server = new Server();
            if (Boolean.getBoolean(PROPERTY_ADMIN_SECURE)) {
                this.addSslConnector(server);
            } else {
                this.addNonSslConnector(server);
            }
            server.setSendServerVersion(false);
            server.setSendDateHeader(true);
            server.setGracefulShutdown(5000);
            QueuedThreadPool threadPool = new QueuedThreadPool(5);
            threadPool.setName("jetty-server-admin");
            server.setThreadPool((ThreadPool)threadPool);
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setSessionHandler(new SessionHandler((SessionManager)new HashSessionManager()));
            ServletHolder sh = new ServletHolder((Servlet)new HttpServiceServlet());
            sh.getInitParameters().put("other.info", TYPE_ADMIN);
            sh.getInitParameters().put("service.vendor", "Eclipse Gyrex");
            sh.getInitParameters().put("service.description", "HTTP Service for administrative purposes only!");
            sh.setRunAsRole("admin");
            contextHandler.addServlet(sh, "/*");
            if (Boolean.getBoolean(PROPERTY_ADMIN_SECURE)) {
                String authenticationPhrase = System.getProperty(PROPERTY_ADMIN_AUTH);
                String[] segments = authenticationPhrase.split("/");
                if (segments.length != 3) {
                    throw new IllegalArgumentException("Illegal authentication configuration. Must be three string separated by '/'");
                }
                if (!StringUtils.equals((String)segments[0], (String)"BASIC")) {
                    throw new IllegalArgumentException("Illegal authentication configuration. Only method 'BASIC' is supported. Found " + segments[0]);
                }
                server.setHandler((Handler)this.createSecurityHandler((Handler)contextHandler, segments[1], segments[2]));
            } else {
                server.setHandler((Handler)contextHandler);
            }
            server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting jetty for admin ui", e);
        }
    }

    private void stopServer() {
        try {
            server.stop();
            server = null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error stopping jetty for admin ui", e);
        }
    }
}

