/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.http.internal.EditApplicationDialog;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiActivator;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutDataFactory;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.service.prefs.BackingStoreException;

public class ApplicationsSection
extends ViewerWithButtonsSectionPart {
    private final ConfigurationPage page;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button activateButton;
    private Button deactivateButton;
    private ListViewer appsList;
    protected IViewerObservableValue selectedValue;

    public ApplicationsSection(Composite parent, ConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.page = page;
        Section section = this.getSection();
        section.setText("Available Applications");
        section.setDescription("Define the available web applications.");
        this.createContent(section);
    }

    void activateButtonPressed() {
        ApplicationRegistration app = this.getSelectedValue();
        if (app == null) {
            return;
        }
        this.getApplicationManager().activate(app.getApplicationId());
        this.markStale();
    }

    void addButtonPressed() {
        EditApplicationDialog dialog = new EditApplicationDialog(SwtUtil.getShell((Widget)this.addButton), this.getApplicationManager(), null);
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationsSection.this.addButtonPressed();
            }
        });
        this.editButton = this.createButton(buttonsPanel, "Edit...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationsSection.this.editButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationsSection.this.removeButtonPressed();
            }
        });
        Label separator = this.getToolkit().createLabel(buttonsPanel, "");
        FormLayoutDataFactory.applyDefaults((Label)separator, (int)1);
        separator = this.getToolkit().createLabel(buttonsPanel, "");
        FormLayoutDataFactory.applyDefaults((Label)separator, (int)1);
        this.activateButton = this.createButton(buttonsPanel, "Activate", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationsSection.this.activateButtonPressed();
            }
        });
        this.deactivateButton = this.createButton(buttonsPanel, "Deactivate", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationsSection.this.deactivateButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.appsList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.appsList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.appsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.appsList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.appsList);
    }

    void deactivateButtonPressed() {
        ApplicationRegistration app = this.getSelectedValue();
        if (app == null) {
            return;
        }
        this.getApplicationManager().deactivate(app.getApplicationId());
        this.markStale();
    }

    void editButtonPressed() {
        ApplicationRegistration app = this.getSelectedValue();
        if (app == null) {
            return;
        }
        EditApplicationDialog dialog = new EditApplicationDialog(SwtUtil.getShell((Widget)this.editButton), this.getApplicationManager(), app);
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    private ApplicationManager getApplicationManager() {
        return (ApplicationManager)HttpUiActivator.getInstance().getService(IApplicationManager.class);
    }

    private DataBindingContext getBindingContext() {
        return this.page.getBindingContext();
    }

    private ApplicationRegistration getSelectedValue() {
        return (ApplicationRegistration)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.appsList;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        ISWTObservableValue listSelection = SWTObservables.observeSelection((Control)this.appsList.getControl());
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        UpdateValueStrategy targetToModel = new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.editButton), (IObservableValue)listSelection, targetToModel, modelToTarget);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)listSelection, targetToModel, modelToTarget);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.activateButton), (IObservableValue)listSelection, targetToModel, modelToTarget);
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.deactivateButton), (IObservableValue)listSelection, targetToModel, modelToTarget);
    }

    public void refresh() {
        try {
            TreeSet registeredApplications = new TreeSet(this.getApplicationManager().getRegisteredApplications());
            ArrayList<ApplicationRegistration> apps = new ArrayList<ApplicationRegistration>();
            for (String appId : registeredApplications) {
                apps.add(this.getApplicationManager().getApplicationRegistration(appId));
            }
            this.appsList.setInput(apps);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        super.refresh();
    }

    void removeButtonPressed() {
        ApplicationRegistration app = this.getSelectedValue();
        if (app == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Context", (String)"Do you really want to delete the application?")) {
            return;
        }
        this.getApplicationManager().unregister(app.getApplicationId());
        this.markStale();
    }
}

