/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ConnectToCloudDialog
extends StatusDialog {
    private final StringDialogField connectStringField = new StringDialogField();
    private final ICloudManager cloudManager;

    public ConnectToCloudDialog(ICloudManager cloudManager, Shell parent) {
        super(parent);
        this.cloudManager = cloudManager;
        this.setTitle("Connect Node");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(60);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.connectStringField.setLabelText("Connect String");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ConnectToCloudDialog.this.validate();
            }
        };
        this.connectStringField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.connectStringField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.connectStringField.getTextControl(null));
        this.connectStringField.setFocus();
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        INodeConfigurer nodeConfigurer = this.cloudManager.getNodeConfigurer(this.cloudManager.getLocalInfo().getNodeId());
        IStatus status = nodeConfigurer.configureConnection(this.connectStringField.getText());
        if (!status.isOK()) {
            Policy.getStatusHandler().show(status, "Error Connecting Node");
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.cloud", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.cloud", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.cloud", message));
    }

    void validate() {
        String connectStr = this.connectStringField.getText();
        if (StringUtils.isBlank((String)connectStr)) {
            this.setInfo("Please enter a connect string.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

