/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.Collection;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudConfigurationPage;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeListSection;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class PendingNodesSection
extends NodeListSection {
    private Button approveButton;

    public PendingNodesSection(Composite parent, CloudConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 256, page.getBindingContext());
        Section section = this.getSection();
        section.setText("Pending Nodes");
        this.createContent(section);
    }

    void approveButtonPressed() {
        INodeDescriptor descriptor = (INodeDescriptor)(this.selectedNodeValue != null ? this.selectedNodeValue.getValue() : null);
        if (descriptor == null) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)SwtUtil.getShell((Widget)this.approveButton), (String)"Approve Node", (String)"The selected node will be approved. Please confirm!")) {
            this.getCloudManager().approveNode(descriptor.getId());
        }
    }

    @Override
    protected void createButtons(Composite parent) {
        this.approveButton = this.createButton(parent, "Approve", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingNodesSection.this.approveButtonPressed();
            }
        });
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.approveButton), (IObservableValue)SWTObservables.observeSelection((Control)this.nodesList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    @Override
    protected Collection<INodeDescriptor> loadNodes(ICloudManager cloudManager) {
        return cloudManager.getPendingNodes();
    }
}

