/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.preferences;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.preferences.ZooKeeperBasedPreferences;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperBasedService;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperHelper;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperPreferencesService
extends ZooKeeperBasedService {
    private static final int MINIMUM_SEGMENT_COUNT = IZooKeeperLayout.PATH_PREFERENCES_ROOT.segmentCount() + 1;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperPreferencesService.class);
    final DeferredProcessingMonitor monitor;
    final String name;
    final ConcurrentMap<String, ZooKeeperBasedPreferences> activeNodesByPath = new ConcurrentHashMap<String, ZooKeeperBasedPreferences>();
    private volatile boolean connected = true;

    public ZooKeeperPreferencesService(String name) {
        super(50L, 3);
        if (!IdHelper.isValidId((String)name)) {
            throw new IllegalArgumentException("invalid name; please use only ascii chars (see IdHelper)");
        }
        this.name = name;
        this.monitor = new DeferredProcessingMonitor();
        this.activate();
    }

    public final void activateNode(ZooKeeperBasedPreferences node) {
        this.activeNodesByPath.put(node.zkPath, node);
    }

    final void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("CLOSED");
        }
    }

    public final void deactivateNode(ZooKeeperBasedPreferences node) {
        this.activeNodesByPath.remove(node.zkPath, node);
    }

    @Override
    protected void disconnect() {
        if (CloudDebug.zooKeeperPreferencesSync) {
            LOG.debug("Disconnecting preferences {}", (Object)this);
        }
        this.connected = false;
    }

    @Override
    protected void doClose() {
        if (CloudDebug.zooKeeperPreferencesSync) {
            LOG.trace("Stack for doClose of service {}", (Object)this, (Object)new Exception("doClose"));
        }
        this.connected = false;
        this.monitor.processEventsThread.interrupt();
        this.monitor.events.clear();
        Collection values = this.activeNodesByPath.values();
        for (ZooKeeperBasedPreferences preferences : values) {
            preferences.dispose();
        }
        this.activeNodesByPath.clear();
    }

    final String getChildPath(String path, String childName) {
        if (childName.indexOf(47) > -1) {
            throw new IllegalArgumentException("invalid child name: " + childName);
        }
        return String.valueOf(path) + '/' + childName;
    }

    final String getParentPath(String path) {
        Path parent = new Path(path);
        if (parent.segmentCount() <= MINIMUM_SEGMENT_COUNT) {
            return null;
        }
        return parent.removeLastSegments(1).toString();
    }

    @Override
    protected String getToStringDetails() {
        StringBuilder details = new StringBuilder();
        details.append(this.name);
        return details.toString();
    }

    public final Stat getVersionInfo(String path) throws Exception {
        this.checkClosed();
        return this.execute(new GetVersionInfo(path));
    }

    public final boolean isActive(ZooKeeperBasedPreferences node) {
        return this.activeNodesByPath.get(node.zkPath) == node;
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void loadNode(String path, boolean forceIfNotConnected) throws Exception {
        block10: {
            this.checkClosed();
            if (CloudDebug.zooKeeperPreferences) {
                LOG.trace("Stack for loadNode request for node {}.", (Object)path, (Object)new Exception("Stack for preference node load request."));
            }
            if (this.connected || forceIfNotConnected) {
                try {
                    this.execute(new LoadNode(path));
                }
                catch (KeeperException.ConnectionLossException e) {
                    if (forceIfNotConnected) {
                        throw e;
                    }
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Ignored exception loading node at {}: {} ", new Object[]{path, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                    }
                    break block10;
                }
                catch (KeeperException.SessionExpiredException e) {
                    if (forceIfNotConnected) {
                        throw e;
                    }
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Ignored exception loading node at {}: {} ", new Object[]{path, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                    }
                    break block10;
                }
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Not loading node at {}: DISCONNECTED ({})", (Object)path, (Object)this);
            }
        }
    }

    @Override
    protected void reconnect() {
        if (CloudDebug.zooKeeperPreferencesSync) {
            LOG.debug("Reconnecting preferences {}", (Object)this);
        }
        this.connected = true;
        HashSet paths = new HashSet(this.activeNodesByPath.keySet());
        for (String path : paths) {
            try {
                this.loadNode(path, true);
            }
            catch (Exception e) {
                LOG.debug("Ignored exception connecting {}: {} ", new Object[]{path, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    }

    public final void refreshChildren(String path, boolean forceSyncWithRemoteVersion) throws Exception {
        this.checkClosed();
        if (!this.activeNodesByPath.containsKey(path)) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.trace("Stack for refreshChildren request for node {}.", (Object)path, (Object)new Exception("refreshChildren"));
        }
        this.execute(new RefreshChildren(path, forceSyncWithRemoteVersion));
    }

    public final void refreshProperties(String path, boolean forceSyncWithRemoteVersion) throws Exception {
        this.checkClosed();
        if (!this.activeNodesByPath.containsKey(path)) {
            return;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.trace("Stack for refreshProperties request for node {}.", (Object)path, (Object)new Exception("refreshProperties"));
        }
        this.execute(new RefreshProperties(path, forceSyncWithRemoteVersion));
    }

    public final void removeNode(String path, int propertiesVersion, int childrenVersion) throws Exception {
        this.checkClosed();
        if (CloudDebug.zooKeeperPreferences) {
            LOG.trace("Stack for removeNode request for node {}.", (Object)path, (Object)new Exception("removeNode"));
        }
        this.execute(new RemoveNode(path, propertiesVersion, childrenVersion));
    }

    public final void shutdown() {
        this.close();
    }

    public final int writeProperties(String path, byte[] propertyBytes, int propertiesVersion) throws Exception {
        this.checkClosed();
        if (!this.activeNodesByPath.containsKey(path)) {
            return -1;
        }
        if (CloudDebug.zooKeeperPreferences) {
            LOG.trace("Stack for writeProperties request for node {}.", (Object)path, (Object)new Exception("writeProperties"));
        }
        return this.execute(new WriteProperties(path, propertyBytes, propertiesVersion));
    }

    private final class DeferredProcessingMonitor
    extends ZooKeeperMonitor {
        final PathEvents events = new PathEvents();
        final Thread processEventsThread;

        public DeferredProcessingMonitor() {
            this.processEventsThread = new Thread(String.valueOf(ZooKeeperPreferencesService.this.toString()) + " EventProcessor"){

                @Override
                public void run() {
                    while (!ZooKeeperPreferencesService.this.isClosed()) {
                        DeferredProcessingMonitor.this.processEventsLoop();
                    }
                }
            };
            this.processEventsThread.start();
        }

        @Override
        protected void childrenChanged(String path) {
            if (ZooKeeperPreferencesService.this.isClosed()) {
                return;
            }
            this.events.childrenChanged(path);
        }

        @Override
        protected void pathCreated(String path) {
            if (ZooKeeperPreferencesService.this.isClosed()) {
                return;
            }
            this.events.created(path);
        }

        @Override
        protected void pathDeleted(String path) {
            if (ZooKeeperPreferencesService.this.isClosed()) {
                return;
            }
            this.events.deleted(path);
        }

        void processEventsLoop() {
            while (!ZooKeeperPreferencesService.this.isClosed()) {
                ZooKeeperBasedPreferences node;
                String path;
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Waiting for events from ZooKeeper.");
                }
                try {
                    path = this.events.next();
                }
                catch (InterruptedException interruptedException) {
                    if (CloudDebug.zooKeeperPreferences) {
                        LOG.debug("Terminating ZooKeeper event processor thread {}.", (Object)this.processEventsThread);
                    }
                    Thread.currentThread().interrupt();
                    return;
                }
                if (CloudDebug.zooKeeperPreferencesSync) {
                    LOG.debug("Processing event for path {}.", (Object)path);
                }
                if ((node = (ZooKeeperBasedPreferences)ZooKeeperPreferencesService.this.activeNodesByPath.get(path)) == null) continue;
                try {
                    Stat stat = ZooKeeperPreferencesService.this.getVersionInfo(path);
                    if (stat == null) {
                        node.removeNode(true);
                        continue;
                    }
                    ZooKeeperPreferencesService.this.loadNode(path, true);
                }
                catch (Exception e) {
                    LOG.error("Exception processing event '{}': {} ", new Object[]{path, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
            }
        }

        @Override
        protected void recordChanged(String path) {
            if (ZooKeeperPreferencesService.this.isClosed()) {
                return;
            }
            this.events.recordChanged(path);
        }
    }

    private final class GetVersionInfo
    extends ZooKeeperBasedService.ZooKeeperCallable<Stat> {
        private final String path;

        private GetVersionInfo(String path) {
            this.path = path;
        }

        @Override
        protected Stat call(ZooKeeper keeper) throws Exception {
            ZooKeeperPreferencesService.this.checkClosed();
            return keeper.exists(this.path, (Watcher)ZooKeeperPreferencesService.this.monitor);
        }
    }

    private class LoadNode
    extends ZooKeeperBasedService.ZooKeeperCallable<Boolean> {
        private final String path;

        public LoadNode(String path) {
            this.path = path;
        }

        @Override
        protected Boolean call(ZooKeeper keeper) throws Exception {
            ZooKeeperPreferencesService.this.checkClosed();
            ZooKeeperBasedPreferences node = (ZooKeeperBasedPreferences)ZooKeeperPreferencesService.this.activeNodesByPath.get(this.path);
            if (node == null) {
                return false;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Loading node {} at {}.", new Object[]{node, this.path});
            }
            if (keeper.exists(this.path, (Watcher)ZooKeeperPreferencesService.this.monitor) == null) {
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Node {} at {} does not exists in ZooKeeper. Nothing to load.", (Object)node, (Object)this.path);
                }
                return true;
            }
            new RefreshProperties(this.path, false).call(keeper);
            new RefreshChildren(this.path, false).call(keeper);
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Done loading node {} (version {}, cversion {}) at {}.", new Object[]{node, node.propertiesVersion, node.childrenVersion, this.path});
            }
            return true;
        }
    }

    static final class PathEvents {
        private final LinkedHashSet<String> pathEvents = new LinkedHashSet();

        PathEvents() {
        }

        public void childrenChanged(String path) {
            this.submitEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            LinkedHashSet<String> linkedHashSet = this.pathEvents;
            synchronized (linkedHashSet) {
                this.pathEvents.clear();
                this.pathEvents.notifyAll();
            }
        }

        public void created(String path) {
            this.submitEvent(path);
        }

        public void deleted(String path) {
            this.submitEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String next() throws InterruptedException {
            String next = null;
            while (next == null) {
                LinkedHashSet<String> linkedHashSet = this.pathEvents;
                synchronized (linkedHashSet) {
                    Iterator iterator = this.pathEvents.iterator();
                    if (iterator.hasNext()) {
                        next = (String)iterator.next();
                        iterator.remove();
                    } else {
                        this.pathEvents.wait();
                    }
                }
            }
            return next;
        }

        public void recordChanged(String path) {
            this.submitEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submitEvent(String path) {
            LinkedHashSet<String> linkedHashSet = this.pathEvents;
            synchronized (linkedHashSet) {
                this.pathEvents.add(path);
                this.pathEvents.notify();
            }
        }
    }

    private final class RefreshChildren
    extends ZooKeeperBasedService.ZooKeeperCallable<Boolean> {
        private final boolean forceSyncWithRemoteVersion;
        private final String path;

        private RefreshChildren(String path, boolean forceSyncWithRemoteVersion) {
            this.path = path;
            this.forceSyncWithRemoteVersion = forceSyncWithRemoteVersion;
        }

        @Override
        protected Boolean call(ZooKeeper keeper) throws Exception {
            block18: {
                ZooKeeperBasedPreferences node;
                block17: {
                    List childrenNames;
                    Stat stat;
                    block16: {
                        ZooKeeperPreferencesService.this.checkClosed();
                        node = (ZooKeeperBasedPreferences)ZooKeeperPreferencesService.this.activeNodesByPath.get(this.path);
                        if (node == null) {
                            return false;
                        }
                        if (CloudDebug.zooKeeperPreferences) {
                            LOG.debug("Reading children for node {} (cversion {}) from ZooKeeper {}", new Object[]{node, node.childrenVersion, this.path});
                        }
                        stat = new Stat();
                        if (!node.childrenModifyLock.tryLock(5L, TimeUnit.MINUTES)) {
                            throw new IllegalStateException(String.format("lock timeout waiting for childrenModifyLock on node '%s'", node));
                        }
                        childrenNames = keeper.getChildren(this.path, (Watcher)ZooKeeperPreferencesService.this.monitor, stat);
                        if (this.forceSyncWithRemoteVersion || node.childrenVersion < stat.getCversion()) break block16;
                        if (CloudDebug.zooKeeperPreferences) {
                            LOG.debug("Not updating children of node {} - local cversion ({}) >= ZooKeeper cversion ({})", new Object[]{node, node.childrenVersion, stat.getCversion()});
                        }
                        Boolean bl = false;
                        node.childrenModifyLock.unlock();
                        return bl;
                    }
                    try {
                        node.loadChildren(childrenNames, stat.getCversion());
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (!this.forceSyncWithRemoteVersion) {
                            if (CloudDebug.zooKeeperPreferences) {
                                LOG.debug("Not updating children of node {} (local cversion {}) - node does not exist in ZooKeeper ({})", new Object[]{node, node.childrenVersion, e.getMessage()});
                            }
                            Boolean bl = false;
                            node.childrenModifyLock.unlock();
                            return bl;
                        }
                        try {
                            if (CloudDebug.zooKeeperPreferences) {
                                LOG.debug("Exception reading children for node {} from ZooKeeper {}. Removing node.", new Object[]{node, this.path, e});
                            }
                            try {
                                node.removeNode(true);
                            }
                            catch (Exception exception) {
                                ZooKeeperPreferencesService.this.deactivateNode(node);
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            node.childrenModifyLock.unlock();
                        }
                    }
                    node.childrenModifyLock.unlock();
                }
                if (!CloudDebug.zooKeeperPreferences) break block18;
                LOG.debug("Done reading children for node {} (version {}) from ZooKeeper {}", new Object[]{node, node.propertiesVersion, this.path});
            }
            return true;
        }
    }

    private final class RefreshProperties
    extends ZooKeeperBasedService.ZooKeeperCallable<Boolean> {
        private final boolean forceSyncWithRemoteVersion;
        private final String path;

        private RefreshProperties(String path, boolean forceSyncWithRemoteVersion) {
            this.path = path;
            this.forceSyncWithRemoteVersion = forceSyncWithRemoteVersion;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Boolean call(ZooKeeper keeper) throws Exception {
            ZooKeeperPreferencesService.this.checkClosed();
            ZooKeeperBasedPreferences node = (ZooKeeperBasedPreferences)ZooKeeperPreferencesService.this.activeNodesByPath.get(this.path);
            if (node == null) {
                return false;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Reading properties for node {} (version {}) from ZooKeeper {}", new Object[]{node, node.propertiesVersion, this.path});
            }
            Stat stat = new Stat();
            try {
                boolean needsLock;
                byte[] bytes = keeper.getData(this.path, (Watcher)ZooKeeperPreferencesService.this.monitor, stat);
                boolean bl = needsLock = !this.forceSyncWithRemoteVersion;
                if (needsLock && !node.propertiesModificationLock.tryLock(5L, TimeUnit.MINUTES)) {
                    throw new IllegalStateException(String.format("lock timeout waiting for childrenModifyLock on node '%s'", node));
                }
                try {
                    if (!this.forceSyncWithRemoteVersion && node.propertiesVersion >= stat.getVersion()) {
                        if (CloudDebug.zooKeeperPreferences) {
                            LOG.debug("Not updating properties of node {} - local version ({}) >= ZooKeeper version ({})", new Object[]{node, node.propertiesVersion, stat.getVersion()});
                        }
                        Boolean bl2 = false;
                        return bl2;
                    }
                    node.loadProperties(bytes, stat.getVersion());
                }
                finally {
                    if (needsLock) {
                        node.propertiesModificationLock.unlock();
                    }
                }
            }
            catch (KeeperException.NoNodeException e) {
                if (!this.forceSyncWithRemoteVersion) {
                    if (!CloudDebug.zooKeeperPreferences) return false;
                    LOG.debug("Not updating properties of node {} (local version {}) - node does not exist in ZooKeeper ({})", new Object[]{node, node.propertiesVersion, e.getMessage()});
                    return false;
                }
                if (CloudDebug.zooKeeperPreferences) {
                    LOG.debug("Exception reading properties for node {} from ZooKeeper {}. Removing node.", new Object[]{node, this.path, e});
                }
                try {
                    node.removeNode(true);
                }
                catch (Exception exception) {
                    ZooKeeperPreferencesService.this.deactivateNode(node);
                }
            }
            if (!CloudDebug.zooKeeperPreferences) return true;
            LOG.debug("Done reading properties for node {} (version {}) from ZooKeeper {}", new Object[]{node, node.propertiesVersion, this.path});
            return true;
        }
    }

    private final class RemoveNode
    extends ZooKeeperBasedService.ZooKeeperCallable<Boolean> {
        private final String path;
        private final int propertiesVersion;
        private final int childrenVersion;

        private RemoveNode(String path, int propertiesVersion, int childrenVersion) {
            this.path = path;
            this.propertiesVersion = propertiesVersion;
            this.childrenVersion = childrenVersion;
        }

        @Override
        protected Boolean call(ZooKeeper keeper) throws Exception {
            block2: {
                ZooKeeperPreferencesService.this.checkClosed();
                try {
                    ZooKeeperHelper.deleteTree(keeper, (IPath)new Path(this.path), this.propertiesVersion, this.childrenVersion);
                }
                catch (KeeperException.NoNodeException e) {
                    if (!CloudDebug.zooKeeperPreferences) break block2;
                    LOG.debug("Node at {} already deleted. ({})", new Object[]{this.path, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                }
            }
            return true;
        }
    }

    private final class WriteProperties
    extends ZooKeeperBasedService.ZooKeeperCallable<Integer> {
        private final String path;
        private final byte[] propertyBytes;
        private final int propertiesVersion;

        private WriteProperties(String path, byte[] propertyBytes, int propertiesVersion) {
            this.path = path;
            this.propertyBytes = propertyBytes;
            this.propertiesVersion = propertiesVersion;
        }

        @Override
        protected Integer call(ZooKeeper keeper) throws Exception {
            ZooKeeperPreferencesService.this.checkClosed();
            ZooKeeperBasedPreferences node = (ZooKeeperBasedPreferences)ZooKeeperPreferencesService.this.activeNodesByPath.get(this.path);
            if (node == null) {
                return -1;
            }
            if (CloudDebug.zooKeeperPreferences) {
                LOG.debug("Writing properties for node {} (version {}) to ZooKeeper {}", new Object[]{node, node.propertiesVersion, this.path});
            }
            if (this.propertiesVersion < 0 && keeper.exists(this.path, (Watcher)ZooKeeperPreferencesService.this.monitor) == null) {
                ZooKeeperHelper.createParents(keeper, (IPath)new Path(this.path));
                Stat stat = null;
                while (stat == null) {
                    keeper.create(this.path, this.propertyBytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    stat = keeper.exists(this.path, (Watcher)ZooKeeperPreferencesService.this.monitor);
                }
                return stat.getVersion();
            }
            return keeper.setData(this.path, this.propertyBytes, this.propertiesVersion).getVersion();
        }
    }
}

