/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.Formatable;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    private int[] referencedColumns;

    public ReferencedColumnsDescriptorImpl(int[] referencedColumns) {
        this.referencedColumns = referencedColumns;
    }

    public ReferencedColumnsDescriptorImpl() {
    }

    public int[] getReferencedColumnPositions() {
        return this.referencedColumns;
    }

    public void readExternal(ObjectInput in) throws IOException {
        int rcLength = in.readInt();
        this.referencedColumns = new int[rcLength];
        for (int i = 0; i < rcLength; ++i) {
            this.referencedColumns[i] = in.readInt();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.referencedColumns.length);
        for (int i = 0; i < this.referencedColumns.length; ++i) {
            out.writeInt(this.referencedColumns[i]);
        }
    }

    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append('(');
        for (int index = 0; index < this.referencedColumns.length; ++index) {
            if (index > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(this.referencedColumns[index]));
        }
        sb.append(')');
        return sb.toString();
    }
}

