/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.TabInfoImpl;

public class DD_Version
implements Formatable {
    private transient DataDictionaryImpl bootingDictionary;
    int majorVersionNumber;
    private int minorVersionNumber;

    public DD_Version() {
    }

    DD_Version(DataDictionaryImpl bootingDictionary, int majorVersionNumber) {
        this.majorVersionNumber = majorVersionNumber;
        this.minorVersionNumber = this.getJBMSMinorVersionNumber();
        this.bootingDictionary = bootingDictionary;
    }

    public String toString() {
        return DD_Version.majorToString(this.majorVersionNumber);
    }

    private static String majorToString(int majorVersionNumber) {
        switch (majorVersionNumber) {
            case 80: {
                return "5.0";
            }
            case 90: {
                return "5.1";
            }
            case 100: {
                return "5.2";
            }
            case 110: {
                return "8.1";
            }
            case 120: {
                return "10.0";
            }
            case 130: {
                return "10.1";
            }
            case 140: {
                return "10.2";
            }
            case 150: {
                return "10.3";
            }
            case 160: {
                return "10.4";
            }
            case 170: {
                return "10.5";
            }
        }
        return null;
    }

    void upgradeIfNeeded(DD_Version dictionaryVersion, TransactionController tc, Properties startParams) throws StandardException {
        if (dictionaryVersion.majorVersionNumber > this.majorVersionNumber) {
            throw StandardException.newException("XCL20.S", (Object)dictionaryVersion, (Object)this);
        }
        boolean minorOnly = false;
        boolean performMajorUpgrade = false;
        boolean softUpgradeRun = false;
        boolean isReadOnly = this.bootingDictionary.af.isReadOnly();
        if (dictionaryVersion.majorVersionNumber == this.majorVersionNumber) {
            if (dictionaryVersion.minorVersionNumber == this.minorVersionNumber) {
                return;
            }
            minorOnly = true;
        } else if (Monitor.isFullUpgrade(startParams, dictionaryVersion.toString())) {
            performMajorUpgrade = true;
        } else {
            softUpgradeRun = true;
        }
        tc.commit();
        if (performMajorUpgrade) {
            String userName = IdUtil.getUserNameFromURLProps(startParams);
            this.doFullUpgrade(tc, dictionaryVersion.majorVersionNumber, IdUtil.getUserAuthorizationId(userName));
        }
        if (!minorOnly && !isReadOnly) {
            DD_Version softUpgradeVersion = (DD_Version)tc.getProperty("derby.softDataDictionaryVersion");
            int softUpgradeMajorVersion = 0;
            if (softUpgradeVersion != null) {
                softUpgradeMajorVersion = softUpgradeVersion.majorVersionNumber;
            }
            if (softUpgradeMajorVersion < this.majorVersionNumber) {
                this.applySafeChanges(tc, dictionaryVersion.majorVersionNumber, softUpgradeMajorVersion);
            }
        }
        this.handleMinorRevisionChange(tc, dictionaryVersion, softUpgradeRun);
        tc.commit();
    }

    private void applySafeChanges(TransactionController tc, int fromMajorVersionNumber, int lastSoftUpgradeVersion) throws StandardException {
        if (lastSoftUpgradeVersion <= 140 && fromMajorVersionNumber <= 140) {
            this.modifySysTableNullability(tc, 11);
            this.modifySysTableNullability(tc, 8);
        }
        tc.setProperty("derby.softDataDictionaryVersion", this, true);
    }

    private void doFullUpgrade(TransactionController tc, int fromMajorVersionNumber, String aid) throws StandardException {
        if (fromMajorVersionNumber < 120) {
            throw StandardException.newException("XCW00.D", (Object)DD_Version.majorToString(fromMajorVersionNumber), (Object)this);
        }
        this.bootingDictionary.updateMetadataSPSes(tc);
        HashSet<String> newlyCreatedRoutines = new HashSet<String>();
        if (fromMajorVersionNumber <= 150) {
            this.bootingDictionary.upgradeMakeCatalog(tc, 19);
        }
        if (fromMajorVersionNumber <= 130) {
            this.bootingDictionary.upgradeMakeCatalog(tc, 16);
            this.bootingDictionary.upgradeMakeCatalog(tc, 17);
            this.bootingDictionary.upgradeMakeCatalog(tc, 18);
        }
        if (fromMajorVersionNumber == 120) {
            this.bootingDictionary.create_10_1_system_procedures(tc, newlyCreatedRoutines, this.bootingDictionary.getSystemUtilSchemaDescriptor().getUUID());
        }
        if (fromMajorVersionNumber <= 130) {
            this.bootingDictionary.create_10_2_system_procedures(tc, newlyCreatedRoutines, this.bootingDictionary.getSystemUtilSchemaDescriptor().getUUID());
            SanityManager.ASSERT(aid != null, "Failed to get new Database Owner authorization");
            this.bootingDictionary.updateSystemSchemaAuthorization(aid, tc);
            newlyCreatedRoutines.add("SYSCS_INPLACE_COMPRESS_TABLE");
            newlyCreatedRoutines.add("SYSCS_GET_RUNTIMESTATISTICS");
            newlyCreatedRoutines.add("SYSCS_SET_RUNTIMESTATISTICS");
            newlyCreatedRoutines.add("SYSCS_COMPRESS_TABLE");
            newlyCreatedRoutines.add("SYSCS_SET_STATISTICS_TIMING");
        }
        if (fromMajorVersionNumber <= 140) {
            this.bootingDictionary.create_10_3_system_procedures(tc, newlyCreatedRoutines);
        }
        if (fromMajorVersionNumber <= 160) {
            this.bootingDictionary.create_10_5_system_procedures(tc, newlyCreatedRoutines);
        }
        this.bootingDictionary.grantPublicAccessToSystemRoutines(newlyCreatedRoutines, tc, aid);
    }

    private void handleMinorRevisionChange(TransactionController tc, DD_Version fromVersion, boolean softUpgradeRun) throws StandardException {
        boolean isReadOnly = this.bootingDictionary.af.isReadOnly();
        if (!isReadOnly) {
            if (fromVersion.majorVersionNumber >= 170) {
                this.bootingDictionary.updateMetadataSPSes(tc);
            } else {
                this.bootingDictionary.clearSPSPlans();
            }
            if (softUpgradeRun) {
                fromVersion.minorVersionNumber = 1;
                DD_Version lastRun = fromVersion;
            } else {
                DD_Version lastRun = this;
                fromVersion.majorVersionNumber = this.majorVersionNumber;
                fromVersion.minorVersionNumber = this.minorVersionNumber;
            }
            tc.setProperty("DataDictionaryVersion", fromVersion, true);
        } else {
            this.bootingDictionary.readOnlyUpgrade = true;
        }
        this.bootingDictionary.clearCaches();
    }

    protected void makeSystemCatalog(TransactionController tc, TabInfoImpl ti) throws StandardException {
        SchemaDescriptor sd = this.bootingDictionary.getSystemSchemaDescriptor();
        this.bootingDictionary.makeCatalog(ti, sd, tc);
    }

    protected void dropSystemCatalogDescription(TransactionController tc, TableDescriptor td) throws StandardException {
        this.bootingDictionary.dropAllColumnDescriptors(td.getUUID(), tc);
        this.bootingDictionary.dropAllConglomerateDescriptors(td, tc);
        this.bootingDictionary.dropTableDescriptor(td, td.getSchemaDescriptor(), tc);
        this.bootingDictionary.clearCaches();
    }

    protected void dropSystemCatalog(TransactionController tc, CatalogRowFactory crf) throws StandardException {
        SchemaDescriptor sd = this.bootingDictionary.getSystemSchemaDescriptor();
        TableDescriptor td = this.bootingDictionary.getTableDescriptor(crf.getCatalogName(), sd, tc);
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        for (int index = 0; index < cds.length; ++index) {
            tc.dropConglomerate(cds[index].getConglomerateNumber());
        }
        this.dropSystemCatalogDescription(tc, td);
    }

    protected void fillIndex(TransactionController tc, long heapConglomerateNumber, TabInfoImpl tabInfo, int indexNumber) throws StandardException {
        long indexConglomerateNumber = tabInfo.getIndexConglomerate(indexNumber);
        IndexRowGenerator indexRowGenerator = tabInfo.getIndexRowGenerator(indexNumber);
        CatalogRowFactory rowFactory = tabInfo.getCatalogRowFactory();
        ExecRow heapRow = rowFactory.makeEmptyRow();
        ExecIndexRow indexableRow = indexRowGenerator.getIndexRowTemplate();
        ScanController heapScan = tc.openScan(heapConglomerateNumber, false, 0, 7, 4, null, null, 1, null, null, -1);
        RowLocation heapLocation = heapScan.newRowLocationTemplate();
        ConglomerateController indexController = tc.openConglomerate(indexConglomerateNumber, false, 4, 7, 4);
        while (heapScan.fetchNext(heapRow.getRowArray())) {
            heapScan.fetchLocation(heapLocation);
            indexRowGenerator.getIndexRow(heapRow, heapLocation, indexableRow, null);
            indexController.insert(indexableRow.getRowArray());
        }
        indexController.close();
        heapScan.close();
    }

    public int getTypeFormatId() {
        return this.majorVersionNumber == 90 ? 402 : 401;
    }

    public final void readExternal(ObjectInput in) throws IOException {
        this.majorVersionNumber = in.readInt();
        this.minorVersionNumber = in.readInt();
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.majorVersionNumber);
        out.writeInt(this.minorVersionNumber);
    }

    private int getJBMSMinorVersionNumber() {
        ProductVersionHolder jbmsVersion = Monitor.getMonitor().getEngineVersion();
        return jbmsVersion.getMinorVersion() * 100 + jbmsVersion.getMaintVersion() + (jbmsVersion.isBeta() ? 0 : 1) + 2;
    }

    private void modifySysTableNullability(TransactionController tc, int catalogNum) throws StandardException {
        TabInfoImpl ti = this.bootingDictionary.getNonCoreTIByNumber(catalogNum);
        CatalogRowFactory rowFactory = ti.getCatalogRowFactory();
        if (catalogNum == 11) {
            this.bootingDictionary.upgradeFixSystemColumnDefinition(rowFactory, 8, tc);
        } else if (catalogNum == 8) {
            this.bootingDictionary.upgradeFixSystemColumnDefinition(rowFactory, 4, tc);
        }
    }

    boolean checkVersion(int requiredMajorVersion, String feature) throws StandardException {
        if (this.majorVersionNumber < requiredMajorVersion) {
            if (feature != null) {
                throw StandardException.newException("XCL47.S", (Object)feature, (Object)DD_Version.majorToString(this.majorVersionNumber), (Object)DD_Version.majorToString(requiredMajorVersion));
            }
            return false;
        }
        return true;
    }
}

