/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.derby.client.ClientDataSourceFactory;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;

public abstract class ClientBaseDataSource
implements Serializable,
Referenceable {
    private static final long serialVersionUID = -7660172643035173692L;
    static boolean SUPPORTS_EUSRIDPWD = false;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private String databaseName;
    private String description;
    private String dataSourceName;
    private int portNumber = 1527;
    public static final int propertyDefault_portNumber = 1527;
    private String serverName = "localhost";
    public static final String propertyDefault_serverName = "localhost";
    public static final int SSL_OFF = 0;
    private static final String SSL_OFF_STR = "off";
    public static final int SSL_BASIC = 1;
    private static final String SSL_BASIC_STR = "basic";
    public static final int SSL_PEER_AUTHENTICATION = 2;
    private static final String SSL_PEER_AUTHENTICATION_STR = "peerAuthentication";
    private String user = "APP";
    public static final String propertyDefault_user = "APP";
    private static final short SECMEC_HAS_NOT_EXPLICITLY_SET = 0;
    protected short securityMechanism = 0;
    public static final short propertyDefault_securityMechanism = 4;
    private boolean retrieveMessageText = true;
    public static final boolean propertyDefault_retrieveMessageText = true;
    private String traceFile;
    private transient int traceFileSuffixIndex_ = 0;
    private String traceDirectory;
    private boolean traceFileAppend = false;
    public static final boolean propertyDefault_traceFileAppend = false;
    private String password;
    public static final short USER_ONLY_SECURITY = 4;
    public static final short CLEAR_TEXT_PASSWORD_SECURITY = 3;
    public static final short ENCRYPTED_PASSWORD_SECURITY = 7;
    public static final short ENCRYPTED_USER_AND_PASSWORD_SECURITY = 9;
    public static final short STRONG_PASSWORD_SUBSTITUTE_SECURITY = 8;
    private int sslMode;
    private boolean createDatabase;
    private boolean shutdownDatabase;
    protected String connectionAttributes = null;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_CONNECTION_CALLS = 1;
    public static final int TRACE_STATEMENT_CALLS = 2;
    public static final int TRACE_RESULT_SET_CALLS = 4;
    public static final int TRACE_DRIVER_CONFIGURATION = 16;
    public static final int TRACE_CONNECTS = 32;
    public static final int TRACE_PROTOCOL_FLOWS = 64;
    public static final int TRACE_RESULT_SET_META_DATA = 128;
    public static final int TRACE_PARAMETER_META_DATA = 256;
    public static final int TRACE_DIAGNOSTICS = 512;
    public static final int TRACE_XA_CALLS = 2048;
    public static final int TRACE_ALL = -1;
    public static final int propertyDefault_traceLevel = -1;
    protected int traceLevel = -1;
    static /* synthetic */ Class class$java$lang$String;

    ClientBaseDataSource() {
    }

    public synchronized void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public synchronized void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static final int getSSLModeFromString(String s) throws SqlException {
        if (s != null) {
            if (s.equalsIgnoreCase(SSL_OFF_STR)) {
                return 0;
            }
            if (s.equalsIgnoreCase(SSL_BASIC_STR)) {
                return 1;
            }
            if (s.equalsIgnoreCase(SSL_PEER_AUTHENTICATION_STR)) {
                return 2;
            }
            throw new SqlException(null, new ClientMessageId("XJ05B.C"), (Object)"ssl", (Object)s, "off, basic, peerAuthentication");
        }
        return 0;
    }

    public static final int getClientSSLMode(Properties properties) throws SqlException {
        return ClientBaseDataSource.getSSLModeFromString(properties.getProperty("ssl"));
    }

    public static String getUser(Properties properties) {
        String userString = properties.getProperty("user");
        return ClientBaseDataSource.parseString(userString, propertyDefault_user);
    }

    public static short getSecurityMechanism(Properties properties) {
        short secmec;
        String securityMechanismString = properties.getProperty("securityMechanism");
        if (securityMechanismString != null) {
            secmec = Short.parseShort(securityMechanismString);
        } else {
            String passwordString = properties.getProperty("password");
            secmec = ClientBaseDataSource.getUpgradedSecurityMechanism(passwordString);
        }
        return secmec;
    }

    public static short getUpgradedSecurityMechanism(String password) {
        if (password == null) {
            return 4;
        }
        return 3;
    }

    public static boolean getRetrieveMessageText(Properties properties) {
        String retrieveMessageTextString = properties.getProperty("retrieveMessageText");
        return ClientBaseDataSource.parseBoolean(retrieveMessageTextString, true);
    }

    public static String getTraceFile(Properties properties) {
        return properties.getProperty("traceFile");
    }

    public static String getTraceDirectory(Properties properties) {
        String traceDirectoryString = ClientBaseDataSource.readSystemProperty("derby.client.traceDirectory");
        if (traceDirectoryString == null) {
            return properties.getProperty("traceDirectory");
        }
        return traceDirectoryString;
    }

    private static String readSystemProperty(final String key) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException se) {
                    return null;
                }
            }
        });
    }

    public static boolean getTraceFileAppend(Properties properties) {
        String traceFileAppendString = properties.getProperty("traceFileAppend");
        return ClientBaseDataSource.parseBoolean(traceFileAppendString, false);
    }

    public static String getPassword(Properties properties) {
        return properties.getProperty("password");
    }

    public final synchronized void setPassword(String password) {
        this.password = password;
    }

    public final String getPassword() {
        return this.password;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), ClientDataSourceFactory.class.getName(), null);
        this.addBeanProperties(ref);
        return ref;
    }

    private void addBeanProperties(Reference ref) {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> returnType;
            String methodName;
            Method m = methods[i];
            if (m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers()) || (methodName = m.getName()).length() < 5 || !methodName.startsWith("get") || !Integer.TYPE.equals(returnType = m.getReturnType()) && !Short.TYPE.equals(returnType) && !(class$java$lang$String == null ? ClientBaseDataSource.class$("java.lang.String") : class$java$lang$String).equals(returnType) && !Boolean.TYPE.equals(returnType)) continue;
            String propertyName = methodName.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(methodName.substring(4));
            try {
                Object ov = m.invoke((Object)this, null);
                String value = ov == null ? null : ov.toString();
                ref.add(new StringRefAddr(propertyName, value));
                continue;
            }
            catch (IllegalAccessException iae) {
                continue;
            }
            catch (InvocationTargetException ite) {
                // empty catch block
            }
        }
    }

    LogWriter computeDncLogWriterForNewConnection(String logWriterInUseSuffix) throws SqlException {
        return ClientBaseDataSource.computeDncLogWriterForNewConnection(this.logWriter, this.traceDirectory, this.traceFile, this.traceFileAppend, this.traceLevel, logWriterInUseSuffix, this.traceFileSuffixIndex_++);
    }

    static LogWriter computeDncLogWriterForNewConnection(PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, int traceLevel, String logWriterInUseSuffix, int traceFileSuffixIndex) throws SqlException {
        int globaltraceFileSuffixIndex = Configuration.traceFileSuffixIndex__++;
        LogWriter dncLogWriter = ClientBaseDataSource.computeDncLogWriter(logWriter, traceDirectory, traceFile, traceFileAppend, logWriterInUseSuffix, traceFileSuffixIndex, traceLevel);
        if (dncLogWriter != null) {
            return dncLogWriter;
        }
        dncLogWriter = ClientBaseDataSource.computeDncLogWriter(null, Configuration.traceDirectory__, Configuration.traceFile__, Configuration.traceFileAppend__, "_global", globaltraceFileSuffixIndex, Configuration.traceLevel__);
        return dncLogWriter;
    }

    static LogWriter computeDncLogWriter(PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, String logWriterInUseSuffix, int traceFileSuffixIndex, int traceLevel) throws SqlException {
        if (traceLevel == 0) {
            return null;
        }
        PrintWriter printWriter = ClientBaseDataSource.computePrintWriter(logWriter, traceDirectory, traceFile, traceFileAppend, logWriterInUseSuffix, traceFileSuffixIndex);
        if (printWriter == null) {
            return null;
        }
        NetLogWriter dncLogWriter = new NetLogWriter(printWriter, traceLevel);
        if (printWriter != logWriter && traceDirectory != null) {
            dncLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return dncLogWriter;
    }

    public static LogWriter computeDncLogWriter(Connection connection, PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, String logWriterInUseSuffix, int traceFileSuffixIndex, int traceLevel) throws SqlException {
        if (traceLevel == 0) {
            return null;
        }
        PrintWriter printWriter = ClientBaseDataSource.computePrintWriter(logWriter, traceDirectory, traceFile, traceFileAppend, logWriterInUseSuffix, traceFileSuffixIndex);
        if (printWriter == null) {
            return null;
        }
        LogWriter dncLogWriter = connection.agent_.newLogWriter_(printWriter, traceLevel);
        if (printWriter != logWriter && traceDirectory != null) {
            dncLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return dncLogWriter;
    }

    static PrintWriter computePrintWriter(PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, String logWriterInUseSuffix, int traceFileSuffixIndex) throws SqlException {
        if (logWriter != null) {
            return logWriter;
        }
        if (traceDirectory != null) {
            String fileName = traceFile == null ? traceDirectory + File.separator + logWriterInUseSuffix + "_" + traceFileSuffixIndex : traceDirectory + File.separator + traceFile + logWriterInUseSuffix + "_" + traceFileSuffixIndex;
            return LogWriter.getPrintWriter(fileName, true);
        }
        if (traceFile != null) {
            return LogWriter.getPrintWriter(traceFile, traceFileAppend);
        }
        return null;
    }

    private static boolean parseBoolean(String boolString, boolean defaultBool) {
        if (boolString != null) {
            return boolString.equalsIgnoreCase("true") || boolString.equalsIgnoreCase("yes");
        }
        return defaultBool;
    }

    private static String parseString(String string, String defaultString) {
        if (string != null) {
            return string;
        }
        return defaultString;
    }

    private static short parseShort(String shortString, short defaultShort) {
        if (shortString != null) {
            return Short.parseShort(shortString);
        }
        return defaultShort;
    }

    private static int parseInt(String intString, int defaultInt) {
        if (intString != null) {
            return Integer.parseInt(intString);
        }
        return defaultInt;
    }

    static Properties tokenizeAttributes(String attributeString, Properties properties) throws SqlException {
        if (attributeString == null) {
            return properties;
        }
        Properties augmentedProperties = properties != null ? (Properties)properties.clone() : new Properties();
        try {
            StringTokenizer attrTokenizer = new StringTokenizer(attributeString, ";");
            while (attrTokenizer.hasMoreTokens()) {
                String v = attrTokenizer.nextToken();
                int eqPos = v.indexOf(61);
                if (eqPos == -1) {
                    throw new SqlException(null, new ClientMessageId("XJ212.S"), attributeString);
                }
                augmentedProperties.setProperty(v.substring(0, eqPos).trim(), v.substring(eqPos + 1).trim());
            }
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ212.S"), (Object)attributeString, (Throwable)e);
        }
        ClientBaseDataSource.checkBoolean(augmentedProperties, "retrieveMessageText");
        return augmentedProperties;
    }

    private static void checkBoolean(Properties set, String attribute) throws SqlException {
        String[] booleanChoices = new String[]{"true", "false"};
        ClientBaseDataSource.checkEnumeration(set, attribute, booleanChoices);
    }

    private static void checkEnumeration(Properties set, String attribute, String[] choices) throws SqlException {
        String value = set.getProperty(attribute);
        if (value == null) {
            return;
        }
        for (int i = 0; i < choices.length; ++i) {
            if (!value.toUpperCase(Locale.ENGLISH).equals(choices[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String choicesStr = "{";
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                choicesStr = choicesStr + "|";
            }
            choicesStr = choicesStr + choices[i];
        }
        throw new SqlException(null, new ClientMessageId("XJ05B.C"), (Object)attribute, (Object)value, choicesStr);
    }

    public synchronized void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public synchronized void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public synchronized void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized void setRetrieveMessageText(boolean retrieveMessageText) {
        this.retrieveMessageText = retrieveMessageText;
    }

    public boolean getRetrieveMessageText() {
        return this.retrieveMessageText;
    }

    public synchronized void setSecurityMechanism(short securityMechanism) {
        this.securityMechanism = securityMechanism;
    }

    public short getSecurityMechanism() {
        return this.getSecurityMechanism(this.getPassword());
    }

    public short getSecurityMechanism(String password) {
        if (this.securityMechanism == 0) {
            return ClientBaseDataSource.getUpgradedSecurityMechanism(password);
        }
        return this.securityMechanism;
    }

    public void setSsl(String mode) throws SqlException {
        this.sslMode = ClientBaseDataSource.getSSLModeFromString(mode);
    }

    public String getSsl() {
        switch (this.sslMode) {
            default: {
                return SSL_OFF_STR;
            }
            case 1: {
                return SSL_BASIC_STR;
            }
            case 2: 
        }
        return SSL_PEER_AUTHENTICATION_STR;
    }

    public final void setCreateDatabase(String create) {
        this.createDatabase = create != null && create.equalsIgnoreCase("create");
    }

    public final String getCreateDatabase() {
        String createstr = null;
        if (this.createDatabase) {
            createstr = "create";
        }
        return createstr;
    }

    public final void setShutdownDatabase(String shutdown) {
        this.shutdownDatabase = shutdown != null && shutdown.equalsIgnoreCase("shutdown");
    }

    public final String getShutdownDatabase() {
        String shutdownstr = null;
        if (this.shutdownDatabase) {
            shutdownstr = "shutdown";
        }
        return shutdownstr;
    }

    public final void setConnectionAttributes(String prop) {
        this.connectionAttributes = prop;
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public static int getTraceLevel(Properties properties) {
        String traceLevelString = ClientBaseDataSource.readSystemProperty("derby.client.traceLevel");
        if (traceLevelString == null) {
            traceLevelString = properties.getProperty("traceLevel");
        }
        return ClientBaseDataSource.parseInt(traceLevelString, -1);
    }

    public synchronized void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public synchronized void setTraceFile(String traceFile) {
        this.traceFile = traceFile;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public synchronized void setTraceDirectory(String traceDirectory) {
        this.traceDirectory = traceDirectory;
    }

    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    public synchronized void setTraceFileAppend(boolean traceFileAppend) {
        this.traceFileAppend = traceFileAppend;
    }

    public boolean getTraceFileAppend() {
        return this.traceFileAppend;
    }

    public int maxStatementsToPool() {
        return 0;
    }

    void updateDataSourceValues(Properties prop) throws SqlException {
        if (prop == null) {
            return;
        }
        if (prop.containsKey("user")) {
            this.setUser(ClientBaseDataSource.getUser(prop));
        }
        if (prop.containsKey("securityMechanism")) {
            this.setSecurityMechanism(ClientBaseDataSource.getSecurityMechanism(prop));
        }
        if (prop.containsKey("traceFile")) {
            this.setTraceFile(ClientBaseDataSource.getTraceFile(prop));
        }
        if (prop.containsKey("traceDirectory")) {
            this.setTraceDirectory(ClientBaseDataSource.getTraceDirectory(prop));
        }
        if (prop.containsKey("traceFileAppend")) {
            this.setTraceFileAppend(ClientBaseDataSource.getTraceFileAppend(prop));
        }
        if (prop.containsKey("retrieveMessageText")) {
            this.setRetrieveMessageText(ClientBaseDataSource.getRetrieveMessageText(prop));
        }
        if (prop.containsKey("ssl")) {
            this.sslMode = ClientBaseDataSource.getClientSSLMode(prop);
        }
    }

    static {
        try {
            new EncryptionManager(null);
            SUPPORTS_EUSRIDPWD = true;
        }
        catch (Exception e) {
            SUPPORTS_EUSRIDPWD = false;
        }
    }
}

