/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.cloud.internal.EditNodeDialog;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.gyrex.cloud.admin.INodeListener;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class NodeListSection
extends ViewerWithButtonsSectionPart {
    private Button editButton;
    protected ListViewer nodesList;
    protected IViewerObservableValue selectedNodeValue;
    private final INodeListener nodeListener = new INodeListener(){

        public void nodesChanged() {
            NodeListSection.this.markStale();
        }
    };
    private ICloudManager cloudManager;
    private final DataBindingContext bindingContext;

    public NodeListSection(Composite parent, FormToolkit toolkit, int style, DataBindingContext bindingContext) {
        super(parent, toolkit, style);
        this.bindingContext = bindingContext;
    }

    protected void createButtons(Composite parent) {
        this.editButton = this.createButton(parent, "Edit...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeListSection.this.editButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.nodesList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.nodesList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, -1).grab(true, true).create());
        this.nodesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.nodesList.setLabelProvider((IBaseLabelProvider)new NodesLabelProvider());
        this.selectedNodeValue = ViewersObservables.observeSingleSelection((Viewer)this.nodesList);
    }

    void editButtonPressed() {
        INodeDescriptor descriptor = (INodeDescriptor)(this.selectedNodeValue != null ? this.selectedNodeValue.getValue() : null);
        if (descriptor == null) {
            return;
        }
        EditNodeDialog dialog = new EditNodeDialog(SwtUtil.getShell((Widget)this.editButton), this.getCloudManager(), descriptor);
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    protected ICloudManager getCloudManager() {
        return this.cloudManager;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        if (this.editButton != null) {
            UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
            modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
            this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.editButton), (IObservableValue)SWTObservables.observeSelection((Control)this.nodesList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
        }
    }

    protected abstract Collection loadNodes(ICloudManager var1);

    public void refresh() {
        if (this.cloudManager != null) {
            this.nodesList.setInput((Object)this.loadNodes(this.cloudManager));
        } else {
            this.nodesList.setInput(null);
        }
        super.refresh();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ICloudManager) {
            if (this.cloudManager != null) {
                this.cloudManager.removeNodeListener(this.nodeListener);
            }
            this.cloudManager = (ICloudManager)input;
            this.cloudManager.addNodeListener(this.nodeListener);
        } else {
            if (this.cloudManager != null) {
                this.cloudManager.removeNodeListener(this.nodeListener);
            }
            this.cloudManager = null;
        }
        return super.setFormInput(input);
    }

    static class NodesLabelProvider
    extends LabelProvider {
        NodesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof INodeDescriptor) {
                INodeDescriptor node = (INodeDescriptor)element;
                if (StringUtils.isNotBlank((String)node.getName())) {
                    return node.getName();
                }
                return node.getId();
            }
            return super.getText(element);
        }
    }
}

