/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DefaultHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(DefaultHandler.class);
    final long _faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    byte[] _favicon;
    boolean _serveIcon = true;
    boolean _showContexts = true;

    public DefaultHandler() {
        try {
            URL fav = this.getClass().getClassLoader().getResource("org/eclipse/jetty/favicon.ico");
            if (fav != null) {
                this._favicon = IO.readBytes((InputStream)fav.openStream());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        if (this._serveIcon && this._favicon != null && method.equals("GET") && request.getRequestURI().equals("/favicon.ico")) {
            if (request.getDateHeader("If-Modified-Since") == this._faviconModified) {
                response.setStatus(304);
            } else {
                response.setStatus(200);
                response.setContentType("image/x-icon");
                response.setContentLength(this._favicon.length);
                response.setDateHeader("Last-Modified", this._faviconModified);
                response.setHeader("Cache-Control", "max-age=360000,public");
                response.getOutputStream().write(this._favicon);
            }
            return;
        }
        if (!method.equals("GET") || !request.getRequestURI().equals("/")) {
            response.sendError(404);
            return;
        }
        response.setStatus(404);
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
        String uri = request.getRequestURI();
        uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
        uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        if (this._showContexts) {
            writer.write("Contexts known to this server are: <ul>");
            Server server = this.getServer();
            Handler[] handlers = server == null ? null : server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; handlers != null && i < handlers.length; ++i) {
                ContextHandler context = (ContextHandler)handlers[i];
                if (context.isRunning()) {
                    writer.write("<li><a href=\"");
                    if (context.getVirtualHosts() != null && context.getVirtualHosts().length > 0) {
                        writer.write("http://" + context.getVirtualHosts()[0] + ":" + request.getLocalPort());
                    }
                    writer.write(context.getContextPath());
                    if (context.getContextPath().length() > 1 && context.getContextPath().endsWith("/")) {
                        writer.write("/");
                    }
                    writer.write("\">");
                    writer.write(context.getContextPath());
                    if (context.getVirtualHosts() != null && context.getVirtualHosts().length > 0) {
                        writer.write("&nbsp;@&nbsp;" + context.getVirtualHosts()[0] + ":" + request.getLocalPort());
                    }
                    writer.write("&nbsp;--->&nbsp;");
                    writer.write(context.toString());
                    writer.write("</a></li>\n");
                    continue;
                }
                writer.write("<li>");
                writer.write(context.getContextPath());
                if (context.getVirtualHosts() != null && context.getVirtualHosts().length > 0) {
                    writer.write("&nbsp;@&nbsp;" + context.getVirtualHosts()[0] + ":" + request.getLocalPort());
                }
                writer.write("&nbsp;--->&nbsp;");
                writer.write(context.toString());
                if (context.isFailed()) {
                    writer.write(" [failed]");
                }
                if (context.isStopped()) {
                    writer.write(" [stopped]");
                }
                writer.write("</li>\n");
            }
        }
        for (int i = 0; i < 10; ++i) {
            writer.write("\n<!-- Padding for IE                  -->");
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        ServletOutputStream out = response.getOutputStream();
        writer.writeTo((OutputStream)out);
        out.close();
    }

    public boolean getServeIcon() {
        return this._serveIcon;
    }

    public void setServeIcon(boolean serveIcon) {
        this._serveIcon = serveIcon;
    }

    public boolean getShowContexts() {
        return this._showContexts;
    }

    public void setShowContexts(boolean show) {
        this._showContexts = show;
    }
}

