/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ProxyRule
extends PatternRule {
    private static final Logger _log = Log.getLogger(ProxyRule.class);
    private HttpClient _client;
    private String _hostHeader;
    private String _proxyTo;
    private int _connectorType = 2;
    private String _maxThreads;
    private String _maxConnections;
    private String _timeout;
    private String _idleTimeout;
    private String _requestHeaderSize;
    private String _requestBufferSize;
    private String _responseHeaderSize;
    private String _responseBufferSize;
    private HashSet<String> _DontProxyHeaders = new HashSet();

    public ProxyRule() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
        this._handling = true;
        this._terminating = true;
    }

    private void initializeClient() throws Exception {
        this._client = new HttpClient();
        this._client.setConnectorType(this._connectorType);
        if (this._maxThreads != null) {
            this._client.setThreadPool((ThreadPool)new QueuedThreadPool(Integer.parseInt(this._maxThreads)));
        } else {
            this._client.setThreadPool((ThreadPool)new QueuedThreadPool());
        }
        if (this._maxConnections != null) {
            this._client.setMaxConnectionsPerAddress(Integer.parseInt(this._maxConnections));
        }
        if (this._timeout != null) {
            this._client.setTimeout(Long.parseLong(this._timeout));
        }
        if (this._idleTimeout != null) {
            this._client.setIdleTimeout(Long.parseLong(this._idleTimeout));
        }
        if (this._requestBufferSize != null) {
            this._client.setRequestBufferSize(Integer.parseInt(this._requestBufferSize));
        }
        if (this._requestHeaderSize != null) {
            this._client.setRequestHeaderSize(Integer.parseInt(this._requestHeaderSize));
        }
        if (this._responseBufferSize != null) {
            this._client.setResponseBufferSize(Integer.parseInt(this._responseBufferSize));
        }
        if (this._responseHeaderSize != null) {
            this._client.setResponseHeaderSize(Integer.parseInt(this._responseHeaderSize));
        }
        this._client.start();
    }

    private HttpURI proxyHttpURI(String uri) throws MalformedURLException {
        return new HttpURI(this._proxyTo + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean hasContent;
        ProxyRule proxyRule = this;
        synchronized (proxyRule) {
            if (this._client == null) {
                try {
                    this.initializeClient();
                }
                catch (Exception e) {
                    throw new IOException("Unable to proxy: " + e.getMessage());
                }
            }
        }
        final int debug = _log.isDebugEnabled() ? request.hashCode() : 0;
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        HttpURI url = this.createUrl(request, debug);
        if (url == null) {
            response.sendError(403);
            return target;
        }
        HttpExchange exchange = new HttpExchange((OutputStream)out, response){
            final /* synthetic */ OutputStream val$out;
            final /* synthetic */ HttpServletResponse val$response;
            {
                this.val$out = outputStream;
                this.val$response = httpServletResponse;
            }

            protected void onRequestCommitted() throws IOException {
            }

            protected void onRequestComplete() throws IOException {
            }

            protected void onResponseComplete() throws IOException {
                if (debug != 0) {
                    _log.debug(debug + " complete", new Object[0]);
                }
            }

            protected void onResponseContent(Buffer content) throws IOException {
                if (debug != 0) {
                    _log.debug(debug + " content" + content.length(), new Object[0]);
                }
                content.writeTo(this.val$out);
            }

            protected void onResponseHeaderComplete() throws IOException {
            }

            protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
                if (debug != 0) {
                    _log.debug(debug + " " + version + " " + status + " " + reason, new Object[0]);
                }
                if (reason != null && reason.length() > 0) {
                    this.val$response.setStatus(status, reason.toString());
                } else {
                    this.val$response.setStatus(status);
                }
            }

            protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
                String s = name.toString().toLowerCase();
                if (!ProxyRule.this._DontProxyHeaders.contains(s) || HttpHeaders.CONNECTION_BUFFER.equals(name) && HttpHeaderValues.CLOSE_BUFFER.equals(value)) {
                    if (debug != 0) {
                        _log.debug(debug + " " + name + ": " + value, new Object[0]);
                    }
                    this.val$response.addHeader(name.toString(), value.toString());
                } else if (debug != 0) {
                    _log.debug(debug + " " + name + "! " + value, new Object[0]);
                }
            }

            protected void onConnectionFailed(Throwable ex) {
                _log.warn(ex.toString(), new Object[0]);
                _log.debug(ex);
                if (!this.val$response.isCommitted()) {
                    this.val$response.setStatus(500);
                }
            }

            protected void onException(Throwable ex) {
                if (ex instanceof EofException) {
                    _log.ignore(ex);
                    return;
                }
                _log.warn(ex.toString(), new Object[0]);
                _log.debug(ex);
                if (!this.val$response.isCommitted()) {
                    this.val$response.setStatus(500);
                }
            }

            protected void onExpire() {
                if (!this.val$response.isCommitted()) {
                    this.val$response.setStatus(504);
                }
            }
        };
        exchange.setMethod(request.getMethod());
        exchange.setURL(url.toString());
        exchange.setVersion(request.getProtocol());
        if (debug != 0) {
            _log.debug("{} {} {} {}", new Object[]{debug, request.getMethod(), url, request.getProtocol()});
        }
        if (hasContent = this.createHeaders(request, debug, exchange)) {
            exchange.setRequestContentSource((InputStream)in);
        }
        long ctimeout = this._client.getTimeout() > exchange.getTimeout() ? this._client.getTimeout() : exchange.getTimeout();
        exchange.setTimeout(ctimeout);
        this._client.send(exchange);
        try {
            exchange.waitForDone();
        }
        catch (InterruptedException e) {
            _log.info("Exception while waiting for response on proxied request", (Throwable)e);
        }
        return target;
    }

    private HttpURI createUrl(HttpServletRequest request, int debug) throws MalformedURLException {
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = uri + "?" + request.getQueryString();
        }
        if ((uri = PathMap.pathInfo((String)this._pattern, (String)uri)) == null) {
            uri = "/";
        }
        HttpURI url = this.proxyHttpURI(uri);
        if (debug != 0) {
            _log.debug(debug + " proxy " + uri + "-->" + url, new Object[0]);
        }
        return url;
    }

    private boolean createHeaders(HttpServletRequest request, int debug, HttpExchange exchange) {
        String connectionHdr = request.getHeader("Connection");
        if (connectionHdr != null && (connectionHdr = connectionHdr.toLowerCase()).indexOf("keep-alive") < 0 && connectionHdr.indexOf("close") < 0) {
            connectionHdr = null;
        }
        if (this._hostHeader != null) {
            exchange.setRequestHeader("Host", this._hostHeader);
        }
        boolean xForwardedFor = false;
        boolean hasContent = false;
        long contentLength = -1L;
        Enumeration enm = request.getHeaderNames();
        while (enm.hasMoreElements()) {
            String hdr = (String)enm.nextElement();
            String lhdr = hdr.toLowerCase();
            if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0 || this._hostHeader != null && "host".equals(lhdr)) continue;
            if ("content-type".equals(lhdr)) {
                hasContent = true;
            } else if ("content-length".equals(lhdr)) {
                contentLength = request.getContentLength();
                exchange.setRequestHeader("Content-Length", Long.toString(contentLength));
                if (contentLength > 0L) {
                    hasContent = true;
                }
            } else if ("x-forwarded-for".equals(lhdr)) {
                xForwardedFor = true;
            }
            Enumeration vals = request.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null) continue;
                if (debug != 0) {
                    _log.debug("{} {} {}", new Object[]{debug, hdr, val});
                }
                exchange.setRequestHeader(hdr, val);
            }
        }
        exchange.setRequestHeader("Via", "1.1 (jetty)");
        if (!xForwardedFor) {
            exchange.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
            exchange.addRequestHeader("X-Forwarded-Proto", request.getScheme());
            exchange.addRequestHeader("X-Forwarded-Host", request.getServerName());
            exchange.addRequestHeader("X-Forwarded-Server", request.getLocalName());
        }
        return hasContent;
    }

    public void setProxyTo(String proxyTo) {
        this._proxyTo = proxyTo;
    }

    public void setMaxThreads(String maxThreads) {
        this._maxThreads = maxThreads;
    }

    public void setMaxConnections(String maxConnections) {
        this._maxConnections = maxConnections;
    }

    public void setTimeout(String timeout) {
        this._timeout = timeout;
    }

    public void setIdleTimeout(String idleTimeout) {
        this._idleTimeout = idleTimeout;
    }

    public void setRequestHeaderSize(String requestHeaderSize) {
        this._requestHeaderSize = requestHeaderSize;
    }

    public void setRequestBufferSize(String requestBufferSize) {
        this._requestBufferSize = requestBufferSize;
    }

    public void setResponseHeaderSize(String responseHeaderSize) {
        this._responseHeaderSize = responseHeaderSize;
    }

    public void setResponseBufferSize(String responseBufferSize) {
        this._responseBufferSize = responseBufferSize;
    }

    public void addDontProxyHeaders(String dontProxyHeader) {
        this._DontProxyHeaders.add(dontProxyHeader);
    }

    public void setConnectorType(int connectorType) {
        this._connectorType = connectorType;
    }
}

