/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import javax.servlet.Servlet;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ApplicationServletHolder
extends ServletHolder {
    public ApplicationServletHolder() {
    }

    public ApplicationServletHolder(Class<? extends Servlet> servlet) {
        super(servlet);
        this.setName(String.valueOf(servlet.getName()) + "-" + super.hashCode());
    }

    public ApplicationServletHolder(Servlet servlet) {
        super(servlet);
        this.setName(String.valueOf(servlet.getClass().getName()) + "-" + super.hashCode());
    }

    private ApplicationServletHandler getApplicationServletHandler() {
        return (ApplicationServletHandler)this.getServletHandler();
    }

    public synchronized Servlet newInstance() throws InstantiationException, IllegalAccessException {
        Class heldClass = this.getHeldClass();
        if (heldClass == null) {
            throw new InstantiationException("no held class: " + this.getClassName());
        }
        IRuntimeContext context = this.getApplicationServletHandler().getApplicationHandler().getApplication().getContext();
        try {
            return (Servlet)context.getInjector().make(heldClass);
        }
        catch (InjectionException e) {
            InstantiationException instantiationException = new InstantiationException(String.format("Error injecting class '%s'. %s", heldClass.getName(), e.getMessage()));
            instantiationException.initCause(e);
            throw instantiationException;
        }
    }
}

