/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.internal.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.common.internal.services.BundleDelegatingClassLoader;
import org.eclipse.gyrex.common.internal.services.IServiceProxyChangeListener;
import org.eclipse.gyrex.common.internal.services.IServiceProxyDisposalListener;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.common.services.ServiceNotAvailableException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProxy<T>
implements IServiceProxy<T>,
InvocationHandler,
ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceProxy.class);
    private final BundleContext bundleContext;
    private final Class<T> serviceInterface;
    private final Filter filter;
    private final CopyOnWriteArraySet<IServiceProxyDisposalListener> disposalListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IServiceProxyChangeListener> changeListeners = new CopyOnWriteArraySet();
    private final SortedMap<ServiceReference<T>, T> serviceReferences = new TreeMap<ServiceReference<T>, T>(new Comparator<ServiceReference<T>>(){

        @Override
        public int compare(ServiceReference<T> r1, ServiceReference<T> r2) {
            return r2.compareTo(r1);
        }
    });
    private final CopyOnWriteArrayList<T> services = new CopyOnWriteArrayList();
    private volatile boolean disposed;
    private volatile boolean active;
    private volatile T dynamicProxy;
    private final Job notifyServiceChangeListeners = new Job("Notify service proxy change listeners"){

        protected IStatus run(IProgressMonitor monitor) {
            if (ServiceProxy.this.disposed) {
                return Status.CANCEL_STATUS;
            }
            for (IServiceProxyChangeListener changeListener : ServiceProxy.this.changeListeners) {
                if (ServiceProxy.this.disposed || monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (changeListener.serviceChanged(ServiceProxy.this)) continue;
                ServiceProxy.this.changeListeners.remove(changeListener);
            }
            return Status.OK_STATUS;
        }
    };

    public static <T> void verifyFilterContainsServiceInterfaceCondition(Class<T> serviceInterface, Filter filter) {
        String requiredObjectClassCondition = String.format("&(objectClass=%s)", serviceInterface.getName());
        if (!filter.toString().contains(requiredObjectClassCondition)) {
            throw new IllegalArgumentException(String.format("Filter '%s' does not match the service class condition '%s'!", filter.toString(), requiredObjectClassCondition));
        }
    }

    public ServiceProxy(BundleContext bundleContext, Class<T> serviceInterface) {
        this.notifyServiceChangeListeners.setSystem(true);
        this.notifyServiceChangeListeners.setPriority(20);
        this.bundleContext = bundleContext;
        this.serviceInterface = serviceInterface;
        String filterString = String.format("(objectClass=%s)", serviceInterface.getName());
        try {
            this.filter = bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(String.format("The framework did not accept our generated filter '%s'. %s", filterString, e.getMessage()), e);
        }
    }

    public ServiceProxy(BundleContext bundleContext, Class<T> serviceInterface, Filter filter) {
        this.notifyServiceChangeListeners.setSystem(true);
        this.notifyServiceChangeListeners.setPriority(20);
        this.bundleContext = bundleContext;
        this.serviceInterface = serviceInterface;
        this.filter = filter;
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null!");
        }
        ServiceProxy.verifyFilterContainsServiceInterfaceCondition(serviceInterface, filter);
    }

    public void addChangeListener(IServiceProxyChangeListener listener) {
        this.checkDisposed();
        this.changeListeners.add(listener);
    }

    public void addDisposalListener(IServiceProxyDisposalListener listener) {
        this.checkDisposed();
        this.disposalListeners.add(listener);
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException(String.format("The service proxy for service '%s' has been disposed.", this.serviceInterface.getName()));
        }
    }

    private T createProxy() {
        this.checkDisposed();
        return (T)Proxy.newProxyInstance(new BundleDelegatingClassLoader(this.bundleContext.getBundle()), new Class[]{this.serviceInterface}, (InvocationHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ServiceReference[] references;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.notifyServiceChangeListeners.cancel();
        SortedMap<ServiceReference<T>, T> sortedMap = this.serviceReferences;
        synchronized (sortedMap) {
            references = this.serviceReferences.keySet().toArray(new ServiceReference[0]);
            this.serviceReferences.clear();
            this.services.clear();
        }
        ServiceReference[] serviceReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference reference = serviceReferenceArray[n2];
            this.bundleContext.ungetService(reference);
            ++n2;
        }
        this.dynamicProxy = null;
        for (IServiceProxyDisposalListener listener : this.disposalListeners) {
            listener.disposed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateServices() {
        SortedMap<ServiceReference<T>, T> sortedMap = this.serviceReferences;
        synchronized (sortedMap) {
            this.services.clear();
            this.services.addAll(this.serviceReferences.values());
        }
    }

    @Override
    public T getProxy() {
        this.checkDisposed();
        if (this.dynamicProxy != null) {
            return this.dynamicProxy;
        }
        this.dynamicProxy = this.createProxy();
        return this.dynamicProxy;
    }

    @Override
    public T getService() throws ServiceNotAvailableException {
        T service;
        this.checkDisposed();
        this.open();
        Iterator<T> iterator = this.services.iterator();
        T t = service = iterator.hasNext() ? (T)iterator.next() : null;
        if (service == null) {
            throw new ServiceNotAvailableException(this.bundleContext, this.serviceInterface.getName());
        }
        return service;
    }

    @Override
    public List<T> getServices() throws IllegalStateException {
        this.checkDisposed();
        this.open();
        return Collections.unmodifiableList(this.services);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkDisposed();
        return method.invoke(this.getService(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        if (this.active) {
            return;
        }
        SortedMap<ServiceReference<T>, T> sortedMap = this.serviceReferences;
        synchronized (sortedMap) {
            this.checkDisposed();
            if (this.active) {
                return;
            }
            this.active = true;
            try {
                this.bundleContext.addServiceListener((ServiceListener)this, this.filter.toString());
                Collection references = this.bundleContext.getServiceReferences(this.serviceInterface, this.filter.toString());
                for (ServiceReference reference : references) {
                    Object service = this.bundleContext.getService(reference);
                    if (service == null) continue;
                    this.serviceReferences.put(reference, service);
                }
                this.doUpdateServices();
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException(String.format("Invalid filter '%s'. %s", this.filter.toString(), e.getMessage()), e);
            }
        }
    }

    public void removeChangeListener(IServiceProxyChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void removeDisposalListener(IServiceProxyDisposalListener listener) {
        this.disposalListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceReference = event.getServiceReference();
        switch (event.getType()) {
            case 1: 
            case 2: {
                SortedMap<ServiceReference<T>, T> sortedMap = this.serviceReferences;
                synchronized (sortedMap) {
                    Object service;
                    if (!this.serviceReferences.containsKey(serviceReference) && (service = this.bundleContext.getService(serviceReference)) != null) {
                        this.serviceReferences.put(serviceReference, service);
                        this.doUpdateServices();
                    }
                    break;
                }
            }
            case 4: 
            case 8: {
                SortedMap<ServiceReference<T>, T> sortedMap = this.serviceReferences;
                synchronized (sortedMap) {
                    Object service;
                    if (this.serviceReferences.containsKey(serviceReference) && (service = this.serviceReferences.remove(serviceReference)) != null) {
                        this.bundleContext.ungetService(serviceReference);
                        this.doUpdateServices();
                    }
                    break;
                }
            }
            default: {
                LOG.warn("Unhandled service event ({}, type {}).", (Object)event, (Object)event.getType());
            }
        }
        this.notifyServiceChangeListeners.schedule(500L);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceProxy [").append(this.serviceInterface.getName()).append("]");
        if (this.disposed) {
            builder.append(" DISPOSED");
        }
        return builder.toString();
    }
}

