/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.admin;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public final class ChannelDescriptor {
    private String id;
    private boolean secure;
    private String certificateId;
    private String secureChannelId;
    private int port;
    private String nodeFilter;

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getId() {
        return this.id;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public int getPort() {
        return this.port;
    }

    public String getSecureChannelId() {
        return this.secureChannelId;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setCertificateId(String certificateId) {
        if (certificateId != null && !IdHelper.isValidId((String)certificateId)) {
            throw new IllegalArgumentException("invalid certificateId");
        }
        this.certificateId = certificateId;
    }

    public void setId(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        this.id = id;
    }

    public void setNodeFilter(String nodeFilter) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)nodeFilter)) {
            try {
                FrameworkUtil.createFilter((String)nodeFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Invalid node filter. Please use LDAP syntax. " + e.getMessage(), e);
            }
        }
        this.nodeFilter = StringUtils.trimToNull((String)nodeFilter);
    }

    public void setPort(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setSecureChannelId(String secureChannelId) {
        if (secureChannelId != null && !IdHelper.isValidId((String)secureChannelId)) {
            throw new IllegalArgumentException("invalid secureChannelId");
        }
        this.secureChannelId = secureChannelId;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", (Object)this.id);
        builder.append("port", this.port);
        builder.append("secure", this.secure);
        builder.append("certificateId", (Object)this.certificateId);
        builder.append("secureChannelId", (Object)this.secureChannelId);
        return builder.toString();
    }
}

