/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.commands.BaseScheduleStoreCmd;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.kohsuke.args4j.Argument;

public class AddEntryToScheduleCmd
extends BaseScheduleStoreCmd {
    @Argument(index=1, usage="the id for the entry to add", required=true, metaVar="ID")
    String entryId;
    @Argument(index=2, usage="a cron expression", required=true, metaVar="EXPR")
    String cronExpression;
    @Argument(index=3, usage="the job type identifier", required=true, metaVar="JOBTYPE")
    String jobTypeId;

    public AddEntryToScheduleCmd() {
        super("<entryId> <cronExpression> <jobTypeId> - Adds an entry to a schedule");
    }

    @Override
    protected void doExecute(String storageId, String scheduleId) throws Exception {
        ScheduleImpl schedule = ScheduleStore.load(storageId, scheduleId, true);
        if (schedule.isEnabled()) {
            this.printf("Schedule %s is enabled, please disable first!", new Object[]{scheduleId});
            return;
        }
        if (JobsActivator.getInstance().getJobProviderRegistry().getProvider(this.jobTypeId) == null) {
            this.printf("ERROR: no provider for job type %s found", new Object[]{this.jobTypeId});
            return;
        }
        ScheduleEntryImpl entry = schedule.createEntry(this.entryId);
        entry.setJobTypeId(this.jobTypeId);
        try {
            entry.setCronExpression(this.cronExpression);
        }
        catch (Exception e) {
            this.printf("ERROR: invalid cron expression, please see http://en.wikipedia.org/wiki/Cron#CRON_expression", new Object[0]);
            this.printf("       %s", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return;
        }
        ScheduleStore.flush(storageId, schedule);
        this.printf("Entry added to schedule %s!", new Object[]{scheduleId});
    }
}

