/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.impl.services.locks.AbstractPool;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.TableNameInfo;

class Deadlock {
    private Deadlock() {
    }

    static Object[] look(AbstractPool factory, LockTable set, LockControl control, ActiveLock startingLock, byte deadlockWake) {
        Hashtable waiters = Deadlock.getWaiters(set);
        Stack<Object> chain = new Stack<Object>();
        chain.push(startingLock.getCompatabilitySpace());
        chain.push(control.getGrants());
        block0: while (!chain.isEmpty()) {
            List grants = (List)chain.peek();
            if (grants.isEmpty()) {
                Deadlock.rollback(chain);
                continue;
            }
            int endStack = grants.size() - 1;
            CompatibilitySpace space = ((Lock)grants.get(endStack)).getCompatabilitySpace();
            for (int gs = 0; gs < endStack; ++gs) {
                if (!space.equals(((Lock)grants.get(gs)).getCompatabilitySpace())) continue;
                chain.push(space);
                Deadlock.rollback(chain);
                continue block0;
            }
            while (true) {
                int index;
                if ((index = chain.indexOf(space)) != -1) {
                    if (index == chain.size() - 1 || index == chain.size() - 2 && index == chain.indexOf(grants) - 1) {
                        ActiveLock lock = (ActiveLock)((Dictionary)waiters).get(space);
                        if (lock.canSkip) {
                            chain.push(space);
                            Deadlock.rollback(chain);
                            continue block0;
                        }
                    }
                    return Deadlock.handle(factory, chain, index, waiters, deadlockWake);
                }
                chain.push(space);
                Lock waitingLock = (Lock)((Dictionary)waiters).get(space);
                if (waitingLock == null) {
                    Deadlock.rollback(chain);
                    continue block0;
                }
                Object waitOn = ((Dictionary)waiters).get(waitingLock);
                if (waitOn instanceof LockControl) {
                    LockControl waitOnControl = (LockControl)waitOn;
                    if (waitOnControl.isUnlocked()) {
                        Deadlock.rollback(chain);
                        continue block0;
                    }
                    chain.push(waitOnControl.getGrants());
                    continue block0;
                }
                space = waitingLock.getCompatabilitySpace();
            }
        }
        return null;
    }

    private static void rollback(Stack chain) {
        do {
            chain.pop();
            if (!chain.isEmpty()) continue;
            return;
        } while (!(chain.peek() instanceof List));
        List grants = (List)chain.peek();
        grants.remove(grants.size() - 1);
    }

    private static Hashtable getWaiters(LockTable set) {
        Hashtable waiters = new Hashtable();
        set.addWaiters(waiters);
        return waiters;
    }

    private static Object[] handle(AbstractPool factory, Stack chain, int start, Dictionary waiters, byte deadlockWake) {
        Object checker = chain.elementAt(0);
        int minLockCount = Integer.MAX_VALUE;
        Object victim = null;
        for (int i = start; i < chain.size(); ++i) {
            Object space = chain.elementAt(i);
            if (space instanceof List) continue;
            if (checker.equals(space) && deadlockWake == 2) {
                victim = checker;
                break;
            }
            LockSpace ls = (LockSpace)space;
            int spaceCount = ls.deadlockCount(minLockCount);
            if (spaceCount > minLockCount) continue;
            victim = space;
            minLockCount = spaceCount;
        }
        if (checker.equals(victim)) {
            Object[] data = new Object[]{chain, waiters};
            return data;
        }
        ActiveLock victimLock = (ActiveLock)waiters.get(victim);
        victimLock.wakeUp((byte)2);
        return null;
    }

    static StandardException buildException(AbstractPool factory, Object[] data) {
        Stack chain = (Stack)data[0];
        Dictionary waiters = (Dictionary)data[1];
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        TableNameInfo tabInfo = null;
        TransactionInfo[] tt = null;
        TransactionController tc = null;
        if (lcc != null) {
            try {
                tc = lcc.getTransactionExecute();
                tabInfo = new TableNameInfo(lcc, false);
                tt = tc.getAccessManager().getTransactionInfo();
            }
            catch (StandardException se) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer(200);
        Hashtable attributes = new Hashtable(17);
        String victimXID = null;
        for (int i = 0; i < chain.size(); ++i) {
            Object space = chain.elementAt(i);
            if (space instanceof List) {
                List grants = (List)space;
                if (grants.size() == 0) continue;
                sb.append("  Granted XID : ");
                for (int j = 0; j < grants.size(); ++j) {
                    if (j != 0) {
                        sb.append(", ");
                    }
                    Lock gl = (Lock)grants.get(j);
                    sb.append("{");
                    sb.append(gl.getCompatabilitySpace().getOwner());
                    sb.append(", ");
                    sb.append(gl.getQualifier());
                    sb.append("} ");
                }
                sb.append('\n');
                continue;
            }
            Lock lock = (Lock)waiters.get(space);
            lock.getLockable().lockAttributes(-1, attributes);
            Deadlock.addInfo(sb, "Lock : ", attributes.get("TYPE"));
            if (tabInfo != null) {
                Long conglomId = (Long)attributes.get("CONGLOMID");
                if (conglomId == null) {
                    Long containerId = (Long)attributes.get("CONTAINERID");
                    try {
                        conglomId = new Long(tc.findConglomid(containerId));
                    }
                    catch (StandardException se) {
                        // empty catch block
                    }
                }
                Deadlock.addInfo(sb, ", ", tabInfo.getTableName(conglomId));
            }
            Deadlock.addInfo(sb, ", ", attributes.get("LOCKNAME"));
            sb.append('\n');
            String xid = String.valueOf(lock.getCompatabilitySpace().getOwner());
            if (i == 0) {
                victimXID = xid;
            }
            Deadlock.addInfo(sb, "  Waiting XID : {", xid);
            Deadlock.addInfo(sb, ", ", lock.getQualifier());
            sb.append("} ");
            if (tt != null) {
                for (int tti = tt.length - 1; tti >= 0; --tti) {
                    String idString;
                    TransactionInfo ti = tt[tti];
                    if (ti == null || (idString = ti.getTransactionIdString()) == null || !idString.equals(xid)) continue;
                    Deadlock.addInfo(sb, ", ", ti.getUsernameString());
                    Deadlock.addInfo(sb, ", ", ti.getStatementTextString());
                    break;
                }
            }
            sb.append('\n');
            attributes.clear();
        }
        StandardException se = StandardException.newException("40001", (Object)sb.toString(), victimXID);
        se.setReport(factory.deadlockMonitor);
        return se;
    }

    private static void addInfo(StringBuffer sb, String desc, Object data) {
        sb.append(desc);
        if (data == null) {
            data = "?";
        }
        sb.append(data);
    }
}

