/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class LOBTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isBlobTypeId();
    }

    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    public boolean storable(TypeId otherType, ClassFactory cf) {
        return otherType.isBlobTypeId();
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "java.sql.Blob";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId);
        return null;
    }

    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "getNullBlob";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in nullMethodName() - " + formatId);
        return null;
    }

    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "getBlobDataValue";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in dataValueMethodName() - " + formatId);
        return null;
    }
}

