/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortScan;

public class SortBufferScan
extends SortScan {
    protected SortBuffer sortBuffer;

    SortBufferScan(MergeSort sort, TransactionManager tran, SortBuffer sortBuffer, boolean hold) {
        super(sort, tran, hold);
        SanityManager.ASSERT(sortBuffer != null);
        this.sortBuffer = sortBuffer;
    }

    public boolean next() throws StandardException {
        SanityManager.ASSERT(this.sortBuffer != null, "next() called on scan after scan was closed.");
        this.current = this.sortBuffer.removeFirst();
        return this.current != null;
    }

    public boolean closeForEndTransaction(boolean closeHeldScan) {
        if (closeHeldScan || !this.hold) {
            this.close();
            return true;
        }
        return false;
    }

    public void close() {
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer);
            this.sortBuffer = null;
        }
        super.close();
    }
}

