/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsConfigurationPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsLabelProvider;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.service.prefs.BackingStoreException;

public class SchedulesSection
extends ViewerWithButtonsSectionPart {
    private Button addButton;
    private Button removeButton;
    private ListViewer dataList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedValue;

    public SchedulesSection(Composite parent, JobsConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Schedules");
        section.setDescription("Manage the available schedules.");
        this.createContent(section);
    }

    void addButtonPressed() {
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulesSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulesSection.this.removeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.dataList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.dataList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.dataList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataList.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.dataList);
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private ISchedule getSelectedValue() {
        return (ISchedule)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.dataList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        try {
            String[] schedulesStorageKeys = ScheduleStore.getSchedules();
            ArrayList<ScheduleImpl> schedules = new ArrayList<ScheduleImpl>(schedulesStorageKeys.length);
            String[] stringArray = schedulesStorageKeys;
            int n = schedulesStorageKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ScheduleImpl schedule = ScheduleStore.load((String)key, (String)ScheduleManagerImpl.getExternalId((String)key), (boolean)false);
                if (schedule != null) {
                    schedules.add(schedule);
                }
                ++n2;
            }
            this.dataList.setInput(schedules);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            this.dataList.setInput((Object)new ISchedule[0]);
        }
        super.refresh();
    }

    void removeButtonPressed() {
        ScheduleImpl schedule = (ScheduleImpl)this.getSelectedValue();
        if (schedule == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Schedule", (String)"Do you really want to delete the schedule?")) {
            return;
        }
        try {
            ScheduleStore.remove((String)schedule.getStorageKey(), (String)schedule.getId());
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.markStale();
    }
}

