/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.internal.applications;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.slf4j.Logger;

public abstract class BaseApplication
implements IApplication {
    private static final long SHUTDOWN_TIMEOUT = 60000L;
    public static final Integer EXIT_ERROR = new Integer(1);
    private static final WeakHashMap<Class<? extends BaseApplication>, CountDownLatch> singletonStopSignals = new WeakHashMap();
    protected boolean debug = false;

    protected static final String[] getApplicationArguments(Map arguments) throws IllegalStateException {
        Object args = arguments.get("application.args");
        if (args == null) {
            throw new IllegalStateException("application arguments missing");
        }
        if (!(args instanceof String[])) {
            throw new IllegalStateException("application arguments of wrong type");
        }
        return (String[])args;
    }

    protected void doCleanup() {
    }

    protected abstract void doStart(Map var1) throws Exception;

    protected abstract Object doStop();

    protected abstract Logger getLogger();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch getStopSignal() {
        WeakHashMap<Class<? extends BaseApplication>, CountDownLatch> weakHashMap = singletonStopSignals;
        synchronized (weakHashMap) {
            return singletonStopSignals.get(this.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialzeStopSignal(CountDownLatch stopSignal) {
        WeakHashMap<Class<? extends BaseApplication>, CountDownLatch> weakHashMap = singletonStopSignals;
        synchronized (weakHashMap) {
            block4: {
                if (!singletonStopSignals.containsKey(this.getClass())) break block4;
                return false;
            }
            return singletonStopSignals.put(this.getClass(), stopSignal) == null;
        }
    }

    protected boolean isActive() {
        CountDownLatch stopSignal = this.getStopSignal();
        return stopSignal != null && stopSignal.getCount() > 0L;
    }

    protected void onApplicationStarted(Map arguments) {
    }

    protected void onBeforeStart(Map arguments) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final Object start(IApplicationContext context) throws Exception {
        Object object;
        CountDownLatch stopSignal;
        block61: {
            if (this.debug) {
                this.getLogger().debug("{} received start request.", (Object)this.getName(), (Object)new Exception(String.format("%s Shutdown Call Stack", this.getName())));
            }
            if (!this.initialzeStopSignal(stopSignal = new CountDownLatch(1))) {
                throw new IllegalStateException(String.format("%s already started!", this.getName()));
            }
            if (this.debug) {
                this.getLogger().debug("Starting {}....", (Object)this.getName());
            }
            this.onBeforeStart(context.getArguments());
            this.doStart(context.getArguments());
            context.applicationRunning();
            if (this.debug) {
                this.getLogger().debug("{} started.", (Object)this.getName());
            }
            this.onApplicationStarted(context.getArguments());
            do {
                try {
                    stopSignal.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            } while (stopSignal.getCount() > 0L && Thread.interrupted());
            if (this.debug) {
                this.getLogger().debug("Stopping {}....", (Object)this.getName());
            }
            object = this.doStop();
            try {
                try {
                    this.doCleanup();
                }
                catch (Exception exception) {
                    this.unsetStopSignal();
                    if (this.debug) {
                        this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                    }
                    CountDownLatch countDownLatch = stopSignal;
                    synchronized (countDownLatch) {
                        stopSignal.notifyAll();
                        break block61;
                    }
                }
            }
            catch (Throwable throwable) {
                this.unsetStopSignal();
                if (this.debug) {
                    this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                }
                CountDownLatch countDownLatch = stopSignal;
                synchronized (countDownLatch) {
                    stopSignal.notifyAll();
                }
                throw throwable;
            }
            this.unsetStopSignal();
            if (this.debug) {
                this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
            }
            CountDownLatch countDownLatch = stopSignal;
            synchronized (countDownLatch) {
                stopSignal.notifyAll();
            }
        }
        return object;
        catch (StartAbortedException startAbortedException) {
            Integer n;
            block63: {
                try {
                    n = EXIT_ERROR;
                }
                catch (Throwable throwable) {
                    block65: {
                        try {
                            try {
                                this.doCleanup();
                            }
                            catch (Exception exception) {
                                this.unsetStopSignal();
                                if (this.debug) {
                                    this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                                }
                                CountDownLatch countDownLatch = stopSignal;
                                synchronized (countDownLatch) {
                                    stopSignal.notifyAll();
                                    break block65;
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            this.unsetStopSignal();
                            if (this.debug) {
                                this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                            }
                            CountDownLatch countDownLatch = stopSignal;
                            synchronized (countDownLatch) {
                                stopSignal.notifyAll();
                            }
                            throw throwable2;
                        }
                        this.unsetStopSignal();
                        if (this.debug) {
                            this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                        }
                        CountDownLatch countDownLatch = stopSignal;
                        synchronized (countDownLatch) {
                            stopSignal.notifyAll();
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        this.doCleanup();
                    }
                    catch (Exception exception) {
                        this.unsetStopSignal();
                        if (this.debug) {
                            this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                        }
                        CountDownLatch countDownLatch = stopSignal;
                        synchronized (countDownLatch) {
                            stopSignal.notifyAll();
                            break block63;
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.unsetStopSignal();
                    if (this.debug) {
                        this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                    }
                    CountDownLatch countDownLatch = stopSignal;
                    synchronized (countDownLatch) {
                        stopSignal.notifyAll();
                    }
                    throw throwable;
                }
                this.unsetStopSignal();
                if (this.debug) {
                    this.getLogger().debug("Signaling completed shutdown of {}...", (Object)this.getName());
                }
                CountDownLatch countDownLatch = stopSignal;
                synchronized (countDownLatch) {
                    stopSignal.notifyAll();
                }
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        CountDownLatch signal;
        if (this.debug) {
            this.getLogger().debug("{} received shutdown request.", (Object)this.getName(), (Object)new Exception(String.format("%s Shutdown Call Stack", this.getName())));
        }
        if ((signal = this.unsetStopSignal()) == null) {
            throw new IllegalStateException(String.format("%s not started!", this.getName()));
        }
        CountDownLatch countDownLatch = signal;
        synchronized (countDownLatch) {
            if (this.debug) {
                this.getLogger().debug("Signaling shutdown for {}...", (Object)this.getName());
            }
            signal.countDown();
            try {
                if (this.debug) {
                    this.getLogger().debug("Waiting for {} to shutdown...", (Object)this.getName());
                }
                signal.wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.debug) {
                this.getLogger().debug("{} shutdown complete.", (Object)this.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch unsetStopSignal() {
        WeakHashMap<Class<? extends BaseApplication>, CountDownLatch> weakHashMap = singletonStopSignals;
        synchronized (weakHashMap) {
            return singletonStopSignals.remove(this.getClass());
        }
    }

    public static class StartAbortedException
    extends RuntimeException {
        private static final long serialVersionUID = 4550058726369912198L;
    }
}

