/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.context.di.IRuntimeContextInjector;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.GyrexContextObject;
import org.eclipse.gyrex.context.internal.IContextDisposalListener;
import org.eclipse.gyrex.context.internal.di.GyrexContextInjectorImpl;
import org.eclipse.gyrex.context.internal.preferences.GyrexContextPreferencesImpl;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.internal.services.GyrexContextServiceLocatorImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyrexContextImpl
extends PlatformObject
implements BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(GyrexContextImpl.class);
    static final String ECLIPSE_CONTEXT_KEY = GyrexContextImpl.class.getName();
    private final IPath contextPath;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final ContextRegistryImpl contextRegistry;
    private final Set<IContextDisposalListener> disposables = new CopyOnWriteArraySet<IContextDisposalListener>();
    private final GyrexContextInjectorImpl injector;
    private final GyrexContextPreferencesImpl preferences;
    private final AtomicLong lastAccessTime = new AtomicLong();
    private final ConcurrentMap<Class<?>, GyrexContextObject> computedObjects = new ConcurrentHashMap();
    private final ConcurrentMap<Bundle, GyrexContextServiceLocatorImpl> serviceLocators = new ConcurrentHashMap<Bundle, GyrexContextServiceLocatorImpl>();

    private static <T> T safeCast(Object object) {
        try {
            return (T)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public GyrexContextImpl(IPath contextPath, ContextRegistryImpl contextRegistry) {
        if (contextPath == null) {
            throw new IllegalArgumentException("context path may not be null");
        }
        if (contextRegistry == null) {
            throw new IllegalArgumentException("context registry may not be null");
        }
        this.contextPath = contextPath;
        this.contextRegistry = contextRegistry;
        this.injector = new GyrexContextInjectorImpl(this);
        this.preferences = new GyrexContextPreferencesImpl(contextRegistry.getHandle(contextPath));
    }

    public void addDisposable(IContextDisposalListener disposable) {
        this.checkDisposed();
        if (!this.disposables.contains(disposable)) {
            this.disposables.add(disposable);
        }
    }

    public void bundleChanged(BundleEvent event) {
        GyrexContextServiceLocatorImpl serviceLocator;
        if (event.getType() == 4 && (serviceLocator = (GyrexContextServiceLocatorImpl)this.serviceLocators.remove(event.getBundle())) != null) {
            serviceLocator.dispose();
            if (ContextDebug.debug) {
                LOG.debug("Bundle {} has been stopped. Its service locator has been removed from {}.", (Object)event.getBundle(), (Object)this);
            }
        }
    }

    private void checkDisposed() throws IllegalStateException {
        if (this.disposed.get()) {
            throw new IllegalStateException("context is disposed");
        }
    }

    public void dispose() {
        if (this.disposed.getAndSet(true)) {
            return;
        }
        try {
            for (IContextDisposalListener disposable : this.disposables) {
                disposable.contextDisposed(this.getHandle());
            }
        }
        finally {
            this.disposables.clear();
            this.injector.dispose();
            try {
                for (GyrexContextServiceLocatorImpl serviceLocator : this.serviceLocators.values()) {
                    serviceLocator.dispose();
                }
            }
            finally {
                this.serviceLocators.clear();
            }
        }
        this.preferences.dispose();
    }

    public void dump(StrBuilder dump) {
        dump.appendln(this.contextPath.toString());
        dump.appendPadding(1, ' ').appendln("Objects");
        if (!this.computedObjects.isEmpty()) {
            for (Map.Entry entry : this.computedObjects.entrySet()) {
                dump.appendPadding(2, ' ').appendln(entry.getKey());
                GyrexContextObject value = (GyrexContextObject)entry.getValue();
                if (value != null) {
                    value.dump(3, dump);
                    continue;
                }
                dump.appendPadding(3, ' ').appendln("(no value)");
            }
        } else {
            dump.appendPadding(2, ' ').appendln("(none)");
        }
        dump.appendPadding(1, ' ').appendln("Preferences");
        this.preferences.dump(2, dump);
    }

    public <T> T get(Class<T> type) throws IllegalArgumentException {
        this.checkDisposed();
        this.trackAccess();
        GyrexContextObject contextObject = (GyrexContextObject)this.computedObjects.get(type);
        if (contextObject == null) {
            if (this.getContextRegistry().getObjectProviderRegistry().getType(type.getName()) == null) {
                return null;
            }
            this.computedObjects.putIfAbsent(type, new GyrexContextObject(this, type));
            contextObject = (GyrexContextObject)this.computedObjects.get(type);
        }
        return GyrexContextImpl.safeCast(contextObject.compute());
    }

    public IPath getContextPath() {
        this.trackAccess();
        return this.contextPath;
    }

    ContextRegistryImpl getContextRegistry() {
        this.checkDisposed();
        return this.contextRegistry;
    }

    public GyrexContextHandle getHandle() {
        return this.contextRegistry.getHandle(this.contextPath);
    }

    public IRuntimeContextInjector getInjector() {
        this.checkDisposed();
        this.trackAccess();
        return this.injector;
    }

    long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public GyrexContextPreferencesImpl getPreferences() {
        this.checkDisposed();
        this.trackAccess();
        return this.preferences;
    }

    public GyrexContextServiceLocatorImpl getServiceLocator(BundleContext bundleContext) {
        this.checkDisposed();
        this.trackAccess();
        GyrexContextServiceLocatorImpl serviceLocator = (GyrexContextServiceLocatorImpl)this.serviceLocators.get(bundleContext.getBundle());
        if (serviceLocator == null) {
            this.serviceLocators.putIfAbsent(bundleContext.getBundle(), new GyrexContextServiceLocatorImpl(this, bundleContext));
            serviceLocator = (GyrexContextServiceLocatorImpl)this.serviceLocators.get(bundleContext.getBundle());
            if (serviceLocator == null) {
                throw new IllegalStateException("unable to create service locator; is the bundle stopped concurrently?");
            }
        }
        return serviceLocator;
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    void removeDisposable(IContextDisposalListener disposable) {
        if (!this.disposed.get()) {
            this.disposables.remove(disposable);
        }
    }

    public String toString() {
        String name;
        if (this.isDisposed()) {
            return String.format("Gyrex Context [DISPOSED (%s)]", this.contextPath);
        }
        try {
            name = this.preferences.get("org.eclipse.gyrex.context", "contextName", (String)null);
        }
        catch (Exception e) {
            name = ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
        return String.format("Gyrex Context [%s (%s)]", name, this.contextPath);
    }

    private void trackAccess() {
        this.lastAccessTime.set(System.currentTimeMillis());
    }
}

