/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationInstance;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationContext;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationDelegateHandler;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationServletHandler;
import org.eclipse.gyrex.http.jetty.internal.app.ResourceProviderHolder;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandler
extends ServletContextHandler {
    public static final String ATTRIBUTE_DEBUG_INFO = ApplicationHandler.class.getName().concat(".debugInfo");
    static final String EMPTY_STRING = "";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHandler.class);
    private final ThreadLocal<String> currentContextPath = new ThreadLocal();
    private final ApplicationRegistration applicationRegistration;
    private final CopyOnWriteArraySet<String> urls = new CopyOnWriteArraySet();
    private final PathMap resourcesMap = new PathMap();
    private final boolean showDebugInfo;
    private ApplicationContext applicationContext;
    private volatile ApplicationInstance applicationInstance;
    private ApplicationDelegateHandler applicationDelegateHandler;
    private SessionHandler sessionHandler;

    public ApplicationHandler(ApplicationRegistration applicationRegistration) {
        boolean bl = this.showDebugInfo = Platform.inDebugMode() || Platform.inDevelopmentMode();
        if (applicationRegistration == null) {
            throw new IllegalArgumentException("application registration must not be null");
        }
        this.setContextPath("/");
        this._scontext = new ApplicationServletContext();
        this.applicationRegistration = applicationRegistration;
        this.getInitParams().putAll(applicationRegistration.getInitProperties());
        this.setDisplayName(String.valueOf(applicationRegistration.getProviderId()) + "@" + applicationRegistration.getApplicationId() + "@" + applicationRegistration.getContext().getContextPath());
    }

    public void addResource(String pathSpec, ResourceProviderHolder resourceProviderHolder) {
        this.resourcesMap.put((Object)pathSpec, (Object)resourceProviderHolder);
    }

    public void addUrl(String url) {
        this.urls.add(url);
    }

    private SessionHandler createSessionHandler() {
        HashSessionManager sessionManager = new HashSessionManager();
        sessionManager.setMaxInactiveInterval(NumberUtils.toInt((String)this.getInitParameter("session.maxInactiveInterval"), (int)1800));
        return new SessionHandler((SessionManager)sessionManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean newContext;
        ContextHandler.Context origContext = baseRequest.getContext();
        if (origContext != null && origContext != this._scontext) {
            throw new IllegalStateException("origContext != this context, nesting/cross-application routing not supported!");
        }
        String origContextPath = baseRequest.getContextPath();
        String origServletPath = baseRequest.getServletPath();
        String origPathInfo = baseRequest.getPathInfo();
        boolean bl = newContext = origContext == null || this.currentContextPath.get() == null;
        if (newContext) {
            this.currentContextPath.set(baseRequest.getContextPath());
        }
        try {
            DispatcherType dispatch;
            String pathInfo;
            String contextPath;
            block20: {
                block21: {
                    contextPath = this.currentContextPath.get();
                    pathInfo = null;
                    dispatch = baseRequest.getDispatcherType();
                    if (!newContext) break block21;
                    if (!DispatcherType.REQUEST.equals((Object)dispatch) && !DispatcherType.ASYNC.equals((Object)dispatch)) break block20;
                    if (!this.checkContext(target, baseRequest, response)) {
                        return;
                    }
                    if (contextPath == null) {
                        return;
                    }
                    if (target.length() > contextPath.length()) {
                        if (contextPath.length() > 1) {
                            target = target.substring(contextPath.length());
                        }
                        pathInfo = target;
                        break block20;
                    } else if (contextPath.length() == 1) {
                        target = "/";
                        pathInfo = "/";
                        break block20;
                    } else {
                        baseRequest.setHandled(true);
                        if (baseRequest.getQueryString() != null) {
                            response.sendRedirect(String.valueOf(URIUtil.addPaths((String)baseRequest.getRequestURI(), (String)"/")) + "?" + baseRequest.getQueryString());
                            return;
                        }
                        response.sendRedirect(URIUtil.addPaths((String)baseRequest.getRequestURI(), (String)"/"));
                        return;
                    }
                }
                if (DispatcherType.FORWARD.equals((Object)dispatch) && target.startsWith("/")) {
                    pathInfo = target;
                }
            }
            baseRequest.setContext(this._scontext);
            if (!DispatcherType.INCLUDE.equals((Object)dispatch) && target.startsWith("/")) {
                if (contextPath.length() == 1) {
                    baseRequest.setContextPath(EMPTY_STRING);
                } else {
                    baseRequest.setContextPath(contextPath);
                }
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(pathInfo);
            }
            if (this.showDebugInfo) {
                StringBuilder dump = new StringBuilder();
                this.dump(dump);
                baseRequest.setAttribute(ATTRIBUTE_DEBUG_INFO, (Object)dump.toString());
            }
            this.nextScope(target, baseRequest, request, response);
            return;
        }
        finally {
            if (newContext) {
                baseRequest.setContext(origContext);
                baseRequest.setContextPath(origContextPath);
                baseRequest.setServletPath(origServletPath);
                baseRequest.setPathInfo(origPathInfo);
                this.currentContextPath.set(null);
            }
        }
    }

    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            ApplicationContext context = this.applicationContext;
            if (context != null) {
                this.applicationContext = null;
                this.applicationInstance = null;
                this.applicationDelegateHandler = null;
                this.applicationRegistration.destroyApplication((IApplicationContext)context);
            }
            this.sessionHandler = null;
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" |").append('\n');
        out.append(indent).append(" +- mounted urls").append('\n');
        for (String url : this.urls) {
            out.append(indent).append(" | ").append(indent).append(" +- ").append(url).append('\n');
        }
    }

    public Application getApplication() {
        Application app;
        ApplicationInstance instance = this.applicationInstance;
        Application application = app = instance != null ? instance.getApplication() : null;
        if (app == null) {
            throw new IllegalStateException("inactive");
        }
        return app;
    }

    public String getApplicationId() {
        return this.applicationRegistration.getApplicationId();
    }

    public ApplicationRegistration getApplicationRegistration() {
        return this.applicationRegistration;
    }

    public String getContextPath() {
        return this.getCurrentContextPath();
    }

    public String getCurrentContextPath() {
        return this.currentContextPath.get();
    }

    public ApplicationDelegateHandler getDelegateHandler() {
        return this.applicationDelegateHandler;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (this.resourcesMap.isEmpty() || path == null || !path.startsWith("/")) {
            return null;
        }
        PathMap.Entry entry = this.resourcesMap.getMatch(path = URIUtil.canonicalPath((String)path));
        if (entry == null) {
            return null;
        }
        ResourceProviderHolder provider = (ResourceProviderHolder)((Object)entry.getValue());
        if (provider == null) {
            return null;
        }
        String pathSpec = (String)entry.getKey();
        String pathInfo = PathMap.pathInfo((String)pathSpec, (String)path);
        URL resourceUrl = provider.getResource(pathInfo);
        if (resourceUrl == null) {
            return null;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)resourceUrl);
            return Resource.newResource((URL)fileURL);
        }
        catch (IOException e) {
            LOG.warn("Error resolving url {} to file based resource. {}", (Object)resourceUrl.toExternalForm(), (Object)ExceptionUtils.getMessage((Throwable)e));
            return null;
        }
    }

    public SecurityHandler getSecurityHandler() {
        return null;
    }

    public ApplicationServletHandler getServletHandler() {
        return (ApplicationServletHandler)this._servletHandler;
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public String[] getUrls() {
        return this.urls.toArray(new String[this.urls.size()]);
    }

    public boolean hasUrls() {
        return this.urls.size() > 0;
    }

    protected boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath((String)target);
        }
        return StringUtil.startsWithIgnoreCase((String)target, (String)"/web-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/meta-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-opt");
    }

    public void removeResource(String pathSpec) {
        this.resourcesMap.remove((Object)pathSpec);
    }

    public void removeUrl(String url) {
        this.urls.remove(url);
    }

    protected void startContext() throws Exception {
        if (JettyDebug.handlers) {
            LOG.debug("Starting {}", (Object)this);
        }
        this.applicationContext = new ApplicationContext(this);
        this._servletHandler = new ApplicationServletHandler(this);
        this.applicationDelegateHandler = new ApplicationDelegateHandler(this);
        this.sessionHandler = this.createSessionHandler();
        this.setHandler((Handler)this.sessionHandler);
        this.sessionHandler.setHandler((Handler)this.applicationDelegateHandler);
        this.applicationDelegateHandler.setHandler((Handler)this._servletHandler);
        try {
            this.applicationInstance = this.applicationRegistration.getApplication((IApplicationContext)this.applicationContext);
            if (this.applicationInstance == null) {
                throw new IllegalStateException("no application instance for " + this.applicationRegistration);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error creating application '%s': %s", StringUtils.trimToEmpty((String)this.getApplicationId()), StringUtils.trimToEmpty((String)e.getMessage())), e);
        }
        Application application = this.applicationInstance.getApplication();
        if (application == null) {
            throw new IllegalStateException("no application object returned from instance for " + this.applicationRegistration);
        }
        this.setAttribute("org.eclipse.gyrex.http.application", application);
        this.setAttribute("org.eclipse.gyrex.context", application.getContext());
        super.startContext();
        this.setWelcomeFiles(new String[]{"index.jsp", "index.html", "index.htm"});
        this.applicationInstance.initialize();
        if (JettyDebug.handlers) {
            LOG.debug("Application {} initialized", (Object)application);
        }
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append("ApplicationHandler@").append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        toString.append('(').append(this.applicationRegistration.getApplicationId()).append('[').append(this.applicationRegistration.getProviderId()).append('@').append(this.applicationRegistration.getContext().getContextPath()).append("])");
        return toString.toString();
    }

    public class ApplicationServletContext
    extends ServletContextHandler.Context {
        public ApplicationServletContext() {
            super((ServletContextHandler)ApplicationHandler.this);
        }

        public ServletContext getContext(String uripath) {
            if (Platform.inDebugMode()) {
                LOG.warn("Illegal cross-application access attempt from {} to {}.", (Object)ApplicationHandler.this.getApplicationId(), (Object)uripath);
            }
            return null;
        }

        public String getContextPath() {
            String contextPath = ApplicationHandler.this.getCurrentContextPath();
            if ("/".equals(contextPath)) {
                return ApplicationHandler.EMPTY_STRING;
            }
            return contextPath;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public String getRealPath(String path) {
            return null;
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }
    }
}

