/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.net.MalformedURLException;
import javax.servlet.Servlet;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class ApplicationResourceServlet
extends DefaultServlet {
    final ApplicationHandler applicationHandler;
    private static final long serialVersionUID = 1L;

    static ServletHolder newHolder(ApplicationHandler applicationHandler) {
        ServletHolder defaultServlet = new ServletHolder((Servlet)new ApplicationResourceServlet(applicationHandler));
        if (Platform.inDevelopmentMode()) {
            defaultServlet.setInitParameter("dirAllowed", "true");
            defaultServlet.setInitParameter("useFileMappedBuffer", "false");
            defaultServlet.setInitParameter("maxCachedFiles", "0");
        } else {
            defaultServlet.setInitParameter("dirAllowed", "false");
            defaultServlet.setInitParameter("maxCacheSize", "2000000");
            defaultServlet.setInitParameter("maxCachedFileSize", "254000");
            defaultServlet.setInitParameter("maxCachedFiles", "1000");
            defaultServlet.setInitParameter("useFileMappedBuffer", "true");
        }
        return defaultServlet;
    }

    public ApplicationResourceServlet(ApplicationHandler applicationHandler) {
        this.applicationHandler = applicationHandler;
    }

    public Resource getResource(String pathInContext) {
        try {
            return this.applicationHandler.getResource(pathInContext);
        }
        catch (MalformedURLException e) {
            Log.ignore((Throwable)e);
            return null;
        }
    }
}

