/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.gyrex.http.application.context.IResourceProvider;
import org.osgi.framework.Bundle;

public class BundleResourceProvider
implements IResourceProvider {
    private final Bundle bundle;
    private Properties mimeMappings;

    public BundleResourceProvider(Bundle bundle) {
        this.bundle = bundle;
    }

    public String getMimeType(String name) {
        String mimeExtension;
        String mimeType;
        int dotIndex;
        if (this.mimeMappings != null && (dotIndex = name.lastIndexOf(46)) != -1 && (mimeType = this.mimeMappings.getProperty(mimeExtension = name.substring(dotIndex + 1))) != null) {
            return mimeType;
        }
        return null;
    }

    public URL getResource(String name) {
        return this.bundle.getEntry(name);
    }

    public Set<String> getResourcePaths(String path) {
        Enumeration entryPaths = this.bundle.getEntryPaths(path);
        if (entryPaths == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            result.add((String)entryPaths.nextElement());
        }
        return result;
    }
}

