/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ApplicationProviderRegistry
extends ServiceTracker<ApplicationProvider, ApplicationProvider> {
    private final ConcurrentMap<String, ApplicationProviderRegistration> providersById = new ConcurrentHashMap<String, ApplicationProviderRegistration>(1);

    public ApplicationProviderRegistry(BundleContext context) {
        super(context, ApplicationProvider.class, null);
    }

    public ApplicationProvider addingService(ServiceReference<ApplicationProvider> reference) {
        ApplicationProvider provider = (ApplicationProvider)super.addingService(reference);
        ApplicationProviderRegistration registration = new ApplicationProviderRegistration(reference, provider);
        this.providersById.putIfAbsent(provider.getId(), registration);
        return provider;
    }

    public ApplicationProviderRegistration getProviderRegistration(String providerId) {
        return (ApplicationProviderRegistration)this.providersById.get(providerId);
    }

    public Map<String, ApplicationProviderRegistration> getRegisteredProviders() {
        return new HashMap<String, ApplicationProviderRegistration>(this.providersById);
    }

    public void removedService(ServiceReference<ApplicationProvider> reference, ApplicationProvider provider) {
        ApplicationProviderRegistration providerRegistration = (ApplicationProviderRegistration)this.providersById.remove(provider.getId());
        if (providerRegistration != null) {
            providerRegistration.destroy();
        }
        super.removedService(reference, (Object)provider);
    }
}

