/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class RepositoryProviderRegistry {
    private final ConcurrentMap<String, RepositoryProvider> registeredRepositoryTypesById = new ConcurrentHashMap<String, RepositoryProvider>(5);
    private ServiceTracker<RepositoryProvider, RepositoryProvider> serviceTracker;

    public void close() {
        this.serviceTracker.close();
        this.serviceTracker = null;
        this.registeredRepositoryTypesById.clear();
    }

    public RepositoryProvider getRepositoryProvider(String repositoryProviderId) {
        if (repositoryProviderId == null) {
            throw new IllegalArgumentException("repository type id must not be null");
        }
        RepositoryProvider repositoryType = (RepositoryProvider)((Object)this.registeredRepositoryTypesById.get(repositoryProviderId));
        if (repositoryType == null) {
            throw new IllegalStateException(MessageFormat.format("repository type \"{0}\" not available", repositoryProviderId));
        }
        return repositoryType;
    }

    public void registerRepositoryProvider(String repositoryProviderId, RepositoryProvider type) throws CoreException {
        if (repositoryProviderId == null) {
            throw new IllegalArgumentException("repository type identifier must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("repository type must not be null");
        }
        RepositoryProvider existing = this.registeredRepositoryTypesById.putIfAbsent(repositoryProviderId, type);
        if (existing != null && existing != type) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gyrex.persistence", 4, MessageFormat.format("A repository type with id \"{0}\" is already registered!", repositoryProviderId), null));
        }
    }

    public void start(BundleContext context) {
        this.serviceTracker = new ServiceTracker<RepositoryProvider, RepositoryProvider>(context, RepositoryProvider.class, null){

            public RepositoryProvider addingService(ServiceReference<RepositoryProvider> reference) {
                RepositoryProvider repositoryType = (RepositoryProvider)((Object)super.addingService(reference));
                if (repositoryType != null) {
                    try {
                        RepositoryProviderRegistry.this.registerRepositoryProvider(repositoryType.getProviderId(), repositoryType);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                return repositoryType;
            }

            public void removedService(ServiceReference<RepositoryProvider> reference, RepositoryProvider service) {
                RepositoryProviderRegistry.this.unregisterRepositoryProvider(service.getProviderId());
                super.removedService(reference, (Object)service);
            }
        };
        this.serviceTracker.open();
    }

    public void unregisterRepositoryProvider(String repositoryProviderId) {
        if (repositoryProviderId == null) {
            throw new IllegalArgumentException("repository type identifier must not be null");
        }
        this.registeredRepositoryTypesById.remove(repositoryProviderId);
    }
}

