/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.solr.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.tests.internal.BaseContextTest;
import org.eclipse.gyrex.persistence.PersistenceUtil;
import org.eclipse.gyrex.persistence.solr.SolrServerRepository;
import org.eclipse.gyrex.persistence.solr.config.SolrServerType;
import org.eclipse.gyrex.persistence.solr.internal.SolrActivator;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.gyrex.persistence.storage.lookup.DefaultRepositoryLookupStrategy;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.eclipse.gyrex.search.internal.solr.documents.PublishJob;
import org.eclipse.gyrex.search.solr.ISolrSearchConstants;
import org.eclipse.gyrex.search.solr.tests.SolrCdsTestsActivator;
import org.junit.BeforeClass;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BaseSolrTest
extends BaseContextTest {
    protected static final String TEST_REPO_ID = BaseSolrTest.class.getSimpleName().toLowerCase();

    static void initDocumentManager(IRuntimeContext context) throws BackingStoreException, IOException, SolrServerException {
        IRepositoryPreferences preferences;
        DefaultRepositoryLookupStrategy.getDefault().setRepository(context, ISolrSearchConstants.SEARCH_CONTENT_TYPE, TEST_REPO_ID);
        try {
            preferences = SolrCdsTestsActivator.getInstance().getRepositoryRegistry().createRepository(TEST_REPO_ID, "org.eclipse.gyrex.persistence.solr").getRepositoryPreferences();
        }
        catch (IllegalStateException illegalStateException) {
            preferences = SolrCdsTestsActivator.getInstance().getRepositoryRegistry().getRepositoryDefinition(TEST_REPO_ID).getRepositoryPreferences();
        }
        Assert.assertNotNull((Object)preferences);
        preferences.put("serverType", SolrServerType.EMBEDDED.name(), false);
        preferences.flush();
        SolrServerRepository repo = (SolrServerRepository)PersistenceUtil.getRepository((IRuntimeContext)context, (RepositoryContentType)ISolrSearchConstants.SEARCH_CONTENT_TYPE);
        repo.getSolrServer().deleteByQuery("*:*");
        repo.getSolrServer().commit();
    }

    @BeforeClass
    public static void setupSolrIndex() throws Exception {
        File configTemplate = new File(FileLocator.toFileURL((URL)SolrCdsTestsActivator.getInstance().getBundle().getEntry("conf-solr")).getFile());
        String coreName = SolrActivator.getEmbeddedSolrCoreName((String)TEST_REPO_ID);
        File indexDir = SolrActivator.getInstance().getEmbeddedSolrCoreBase(coreName);
        if (!indexDir.isDirectory()) {
            indexDir.mkdirs();
        }
        FileUtils.copyDirectory((File)configTemplate, (File)indexDir);
        CoreContainer coreContainer = SolrActivator.getInstance().getEmbeddedCoreContainer();
        if (coreContainer == null) {
            throw new IllegalStateException("no coreContainer");
        }
        SolrCore core = coreContainer.getCore(coreName);
        try {
            if (core == null) {
                EmbeddedSolrServer adminServer = new EmbeddedSolrServer(coreContainer, null);
                CoreAdminRequest.createCore((String)coreName, (String)coreName, (SolrServer)adminServer);
            } else {
                coreContainer.reload(coreName);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }

    static void waitForPendingSolrPublishOps() {
        try {
            Job.getJobManager().join(PublishJob.FAMILY, null);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    protected IPath getPrimaryTestContextPath() {
        return new Path("/__internal/org/eclipse/gyrex/cds/solr/tests");
    }

    protected void initContext() throws Exception {
        IRuntimeContext context = this.getContext();
        BaseSolrTest.initDocumentManager(context);
    }
}

