/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.internal.solr.query.BaseFilter;
import org.eclipse.gyrex.search.query.FacetSelectionStrategy;
import org.eclipse.gyrex.search.query.FilterType;
import org.eclipse.gyrex.search.query.IFacetFilter;
import org.eclipse.gyrex.search.query.QueryUtil;
import org.eclipse.gyrex.search.query.TermCombination;

public class FacetFilter
extends BaseFilter
implements IFacetFilter {
    private final IFacet facet;
    private TermCombination combination;
    private FacetSelectionStrategy selectionStrategy;
    private final List<String> values = new ArrayList<String>(1);

    public FacetFilter(IFacet facet) {
        this.facet = facet;
    }

    @Override
    public IFacetFilter combineUsing(TermCombination combination) {
        this.combination = combination;
        return this;
    }

    @Override
    public IFacet getFacet() {
        return this.facet;
    }

    @Override
    public FacetSelectionStrategy getSelectionStrategy() {
        if (this.selectionStrategy != null) {
            return this.selectionStrategy;
        }
        return this.getFacet().getSelectionStrategy();
    }

    @Override
    public TermCombination getTermCombination() {
        if (this.combination != null) {
            return this.combination;
        }
        return this.getFacet().getTermCombination();
    }

    @Override
    public FacetFilter ofType(FilterType type) {
        return (FacetFilter)super.ofType(type);
    }

    @Override
    public IFacetFilter select(FacetSelectionStrategy selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
        return this;
    }

    @Override
    public String toFilterQuery() {
        if (this.values.isEmpty()) {
            return null;
        }
        StringBuilder q = new StringBuilder();
        if (this.getType() == FilterType.EXCLUSIVE) {
            q.append('-');
        }
        if (this.getSelectionStrategy() == FacetSelectionStrategy.MULTI) {
            q.append("{!tag=").append(this.facet.getAttributeId()).append('}');
        }
        q.append(this.facet.getAttributeId()).append(':');
        if (this.values.size() > 1) {
            q.append('(');
            String separator = null;
            for (String value : this.values) {
                if (separator != null) {
                    q.append(separator);
                } else {
                    separator = this.getTermCombination() == TermCombination.AND ? " AND " : " OR ";
                }
                q.append(QueryUtil.escapeQueryChars(value));
            }
            q.append(')');
        } else {
            q.append(QueryUtil.escapeQueryChars(this.values.get(0)));
        }
        return q.toString();
    }

    @Override
    public IFacetFilter withValue(String value) {
        this.values.add(value);
        return this;
    }

    @Override
    public IFacetFilter withValues(String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.values.add(value);
            ++n2;
        }
        return this;
    }
}

