/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.osgi.service.prefs.BackingStoreException;

public class ApplicationMountsPropertySource
implements IPropertySource {
    private final SortedSet<String> mounts;

    public ApplicationMountsPropertySource(ApplicationRegistration applicationRegistration) {
        IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
        this.mounts = new TreeSet<String>();
        try {
            String[] urls;
            String[] stringArray = urls = urlsNode.keys();
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                String appId = urlsNode.get(url, "");
                if (appId.equals(applicationRegistration.getApplicationId())) {
                    this.mounts.add(url);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            this.mounts.add(e.getMessage());
        }
    }

    public Object getEditableValue() {
        return this.mounts;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (String url : this.mounts) {
            descriptors.add(new PropertyDescriptor((Object)url, "URL"));
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        return id;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

