/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.registry.ApplicationCustomizer;
import org.eclipse.gyrex.http.registry.internal.RegistryApplicationProvider;

public class RegistryApplication
extends Application {
    private final AtomicReference<ApplicationCustomizer> customizerRef = new AtomicReference();

    RegistryApplication(String id, IRuntimeContext context) {
        super(id, context);
    }

    protected void doDestroy() {
        RegistryApplicationProvider.getInstance().removeApplication(this.getId());
        try {
            ApplicationCustomizer customizer = this.getCustomizer();
            if (customizer != null) {
                customizer.onDestroy(this);
            }
        }
        finally {
            this.setCustomizer(null);
        }
    }

    protected void doInit() throws CoreException {
        RegistryApplicationProvider.getInstance().initApplication(this);
        ApplicationCustomizer customizer = this.getCustomizer();
        if (customizer != null) {
            customizer.onInit(this);
        }
    }

    protected IApplicationContext getApplicationContext() {
        return super.getApplicationContext();
    }

    ApplicationCustomizer getCustomizer() {
        return this.customizerRef.get();
    }

    void setCustomizer(ApplicationCustomizer customizer) {
        this.customizerRef.set(customizer);
    }
}

