/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddContextDialog
extends StatusDialog {
    private final StringDialogField pathField = new StringDialogField();
    private final StringDialogField nameField = new StringDialogField();
    private final ContextRegistryImpl registryImpl;

    public AddContextDialog(Shell parent, ContextRegistryImpl registryImpl) {
        super(parent);
        this.registryImpl = registryImpl;
        this.setTitle("New Software Repository");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.pathField.setLabelText("Path");
        this.nameField.setLabelText("Name");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddContextDialog.this.validate();
            }
        };
        this.pathField.setDialogFieldListener(validateListener);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.pathField, this.nameField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.pathField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            ContextDefinition contextDefinition = new ContextDefinition(new Path(this.pathField.getText()).makeAbsolute().addTrailingSeparator());
            contextDefinition.setName(this.nameField.getText());
            this.registryImpl.saveDefinition(contextDefinition);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.context", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.context", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.context", message));
    }

    void validate() {
        String id = this.pathField.getText();
        if (StringUtils.isNotBlank((String)id) && !Path.EMPTY.isValidPath(id)) {
            this.setError("The entered path is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_' and '/' as separator.");
            return;
        }
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a repository id.");
            return;
        }
        String name = this.nameField.getText();
        if (StringUtils.isBlank((String)name)) {
            this.setInfo("Please enter a context name.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

