/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import ch.qos.logback.classic.Level;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.logback.config.internal.model.Appender;
import org.eclipse.gyrex.logback.config.internal.model.ConsoleAppender;
import org.eclipse.gyrex.logback.config.internal.model.FileAppender;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddAppenderDialog
extends StatusDialog {
    private final SelectionButtonDialogFieldGroup typeField = new SelectionButtonDialogFieldGroup(16, new String[]{"Console", "File"}, 2);
    private final StringDialogField nameField = new StringDialogField();
    private final StringDialogField fileNameField = new StringDialogField();
    private final SelectionButtonDialogField compressField = new SelectionButtonDialogField(32);
    private final SelectionButtonDialogFieldGroup rotationTypeField = new SelectionButtonDialogFieldGroup(16, new String[]{"never", "daily", "weekly", "monthly", "based on size"}, 5);
    private final StringDialogField maxFileSizeField = new StringDialogField();
    private final StringDialogField maxHistoryField = new StringDialogField();
    private final SelectionButtonDialogFieldGroup thresholdField = new SelectionButtonDialogFieldGroup(16, new String[]{"No filter", "DEBUG", "INFO", "WARN", "ERROR"}, 5);
    private final StringDialogField siftingPropertyNameField = new StringDialogField();
    private final StringDialogField siftingPropertyDefaultField = new StringDialogField();
    private Appender appender;

    public AddAppenderDialog(Shell parent) {
        super(parent);
        this.setTitle("New Appender");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.typeField.setLabelText("Type");
        this.nameField.setLabelText("Appender Name");
        this.fileNameField.setLabelText("File Name");
        this.rotationTypeField.setLabelText("Rotate log files");
        this.compressField.setLabelText("Compress rotated logs");
        this.maxHistoryField.setLabelText("Number of rotated logs to keep");
        this.maxFileSizeField.setLabelText("Rotate when log file is greater then");
        this.thresholdField.setLabelText("Filter log event below");
        this.siftingPropertyNameField.setLabelText("Separate log files based on MDC property:");
        this.siftingPropertyDefaultField.setLabelText("Default value if MDC property is not set:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddAppenderDialog.this.updateEnabledFields();
                AddAppenderDialog.this.validate();
            }
        };
        this.typeField.setDialogFieldListener(validateListener);
        this.nameField.setDialogFieldListener(validateListener);
        this.fileNameField.setDialogFieldListener(validateListener);
        this.rotationTypeField.setDialogFieldListener(validateListener);
        this.maxFileSizeField.setDialogFieldListener(validateListener);
        this.maxHistoryField.setDialogFieldListener(validateListener);
        this.siftingPropertyNameField.setDialogFieldListener(validateListener);
        this.compressField.setSelection(true);
        this.updateEnabledFields();
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.typeField, this.nameField, this.thresholdField, new Separator(), this.fileNameField, new Separator(), this.rotationTypeField, this.compressField, this.maxHistoryField, this.maxFileSizeField, new Separator(), this.siftingPropertyNameField, this.siftingPropertyDefaultField}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fileNameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    public Appender getAppender() {
        return this.appender;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            if (this.typeField.isSelected(0)) {
                this.appender = new ConsoleAppender();
            } else {
                FileAppender fileAppender = new FileAppender();
                this.appender = fileAppender;
                fileAppender.setFileName(this.fileNameField.getText());
                if (this.rotationTypeField.isSelected(1) || this.rotationTypeField.isSelected(2) || this.rotationTypeField.isSelected(3)) {
                    if (this.rotationTypeField.isSelected(1)) {
                        fileAppender.setRotationPolicy(FileAppender.RotationPolicy.DAILY);
                    } else if (this.rotationTypeField.isSelected(2)) {
                        fileAppender.setRotationPolicy(FileAppender.RotationPolicy.WEEKLY);
                    } else if (this.rotationTypeField.isSelected(3)) {
                        fileAppender.setRotationPolicy(FileAppender.RotationPolicy.MONTHLY);
                    }
                    fileAppender.setMaxHistory(StringUtils.trimToNull((String)this.maxHistoryField.getText()));
                } else if (this.rotationTypeField.isSelected(4)) {
                    fileAppender.setRotationPolicy(FileAppender.RotationPolicy.SIZE);
                    fileAppender.setMaxFileSize(StringUtils.trimToNull((String)this.maxFileSizeField.getText()));
                }
                fileAppender.setCompressRotatedLogs(this.compressField.isSelected());
                String siftingMdcPropertyName = StringUtils.trimToNull((String)this.siftingPropertyNameField.getText());
                if (siftingMdcPropertyName != null) {
                    fileAppender.setSiftingMdcPropertyName(siftingMdcPropertyName);
                    fileAppender.setSiftingMdcPropertyDefaultValue(StringUtils.trimToNull((String)this.siftingPropertyDefaultField.getText()));
                }
            }
            if (this.thresholdField.isSelected(1)) {
                this.appender.setThreshold(Level.DEBUG);
            } else if (this.thresholdField.isSelected(2)) {
                this.appender.setThreshold(Level.INFO);
            } else if (this.thresholdField.isSelected(3)) {
                this.appender.setThreshold(Level.WARN);
            } else if (this.thresholdField.isSelected(4)) {
                this.appender.setThreshold(Level.ERROR);
            }
            this.appender.setName(this.nameField.getText());
        }
        catch (Exception e) {
            this.appender = null;
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.logback", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.logback", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.logback", message));
    }

    void updateEnabledFields() {
        if (this.typeField.isSelected(1)) {
            this.fileNameField.setEnabled(true);
            this.siftingPropertyNameField.setEnabled(true);
            this.siftingPropertyDefaultField.setEnabled(StringUtils.isNotBlank((String)this.siftingPropertyNameField.getText()));
            this.rotationTypeField.setEnabled(true);
            if (this.rotationTypeField.isSelected(1) || this.rotationTypeField.isSelected(2) || this.rotationTypeField.isSelected(3)) {
                this.maxFileSizeField.setEnabled(false);
                this.maxHistoryField.setEnabled(true);
                this.compressField.setEnabled(true);
            } else if (this.rotationTypeField.isSelected(4)) {
                this.maxFileSizeField.setEnabled(true);
                this.maxHistoryField.setEnabled(false);
                this.compressField.setEnabled(true);
            } else {
                this.maxFileSizeField.setEnabled(false);
                this.maxHistoryField.setEnabled(false);
                this.compressField.setEnabled(false);
            }
        } else {
            this.fileNameField.setEnabled(false);
            this.rotationTypeField.setEnabled(false);
            this.maxFileSizeField.setEnabled(false);
            this.maxHistoryField.setEnabled(false);
            this.compressField.setEnabled(false);
            this.siftingPropertyNameField.setEnabled(false);
            this.siftingPropertyDefaultField.setEnabled(false);
        }
    }

    void validate() {
        if (!this.typeField.isSelected(0) && !this.typeField.isSelected(1)) {
            this.setInfo("Please select an appender type.");
            return;
        }
        String name = this.nameField.getText();
        if (StringUtils.isBlank((String)name)) {
            this.setInfo("Please enter an appender name.");
            return;
        }
        if (!IdHelper.isValidId((String)name)) {
            this.setError("The entered appender name is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        if (this.typeField.isSelected(1)) {
            String fileName = this.fileNameField.getText();
            if (StringUtils.isBlank((String)fileName)) {
                this.setInfo("Please enter a file name.");
                return;
            }
            if (!IdHelper.isValidId((String)fileName)) {
                this.setError("The entered file name is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
                return;
            }
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

