/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rwt.internal.lifecycle.IRenderRunnable;
import org.eclipse.rwt.internal.protocol.ClientObjectAdapter;
import org.eclipse.rwt.internal.protocol.IClientObjectAdapter;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IdGenerator;
import org.eclipse.swt.widgets.Widget;

public final class WidgetAdapter
implements IWidgetAdapter,
IClientObjectAdapter,
SerializableCompatibility {
    private final String id;
    private boolean initialized;
    private transient Map<String, Object> preservedValues;
    private String jsParent;
    private transient IRenderRunnable renderRunnable;
    private transient String cachedVariant;
    private ClientObjectAdapter gcObjectAdapter;

    public WidgetAdapter() {
        this(IdGenerator.getInstance().newId("w"));
    }

    public WidgetAdapter(String id) {
        this.id = id;
        this.initialize();
    }

    private void initialize() {
        this.preservedValues = new HashMap<String, Object>();
    }

    public String getId() {
        return this.id;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void preserve(String propertyName, Object value) {
        this.preservedValues.put(propertyName, value);
    }

    public Object getPreserved(String propertyName) {
        return this.preservedValues.get(propertyName);
    }

    public void clearPreserved() {
        this.preservedValues.clear();
    }

    public String getJSParent() {
        return this.jsParent;
    }

    public void setJSParent(String jsParent) {
        this.jsParent = jsParent;
    }

    public void setRenderRunnable(IRenderRunnable renderRunnable) {
        if (this.renderRunnable != null) {
            throw new IllegalStateException("A renderRunnable was already set.");
        }
        this.renderRunnable = renderRunnable;
    }

    public IRenderRunnable getRenderRunnable() {
        return this.renderRunnable;
    }

    public void clearRenderRunnable() {
        this.renderRunnable = null;
    }

    public String getCachedVariant() {
        return this.cachedVariant;
    }

    public void setCachedVariant(String cachedVariant) {
        this.cachedVariant = cachedVariant;
    }

    public void markDisposed(Widget widget) {
        if (this.initialized) {
            DisposedWidgets.add(widget);
        }
    }

    public Adaptable getGCForClient() {
        if (this.gcObjectAdapter == null) {
            this.gcObjectAdapter = new ClientObjectAdapter("gc");
        }
        return this.createGcAdaptable();
    }

    private Adaptable createGcAdaptable() {
        return new Adaptable(){

            @Override
            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == IClientObjectAdapter.class) {
                    return (T)WidgetAdapter.this.gcObjectAdapter;
                }
                return null;
            }
        };
    }

    private Object readResolve() {
        this.initialize();
        return this;
    }
}

