/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class FontDialog
extends Dialog {
    private static final int BUTTON_WIDTH = 60;
    private FontData fontData;
    private RGB rgb;
    private Text txtFontFamily;
    private List lstFontFamily;
    private Spinner spFontSize;
    private Button cbBold;
    private Button cbItalic;
    private Label lblColor;
    private Label lblPreview;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
        this.setText(RWTMessages.getMessage("RWT_FontDialogTitle"));
    }

    public FontData[] getFontList() {
        FontData[] result = null;
        if (this.fontData != null) {
            result = new FontData[]{this.fontData};
        }
        return result;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public FontData open() {
        this.prepareOpen();
        this.runEventLoop(this.shell);
        return this.fontData;
    }

    protected void prepareOpen() {
        this.initializeDefaults();
        this.createShell();
        this.createControls();
        this.updateControls();
        this.addChangeListeners();
        this.layoutAndCenterShell();
    }

    private void initializeDefaults() {
        if (this.fontData == null) {
            Display display = this.parent.getDisplay();
            FontData systemFontData = display.getSystemFont().getFontData()[0];
            String fontName = FontDialog.getFirstFontName(systemFontData.getName());
            int fontHeight = systemFontData.getHeight();
            int fontStyle = systemFontData.getStyle();
            this.fontData = new FontData(fontName, fontHeight, fontStyle);
        }
        if (this.rgb == null) {
            this.rgb = new RGB(0, 0, 0);
        }
    }

    static String getFirstFontName(String fontName) {
        String result = fontName;
        int index = result.indexOf(44);
        if (index != -1) {
            result = result.substring(0, index);
        }
        if ((result = result.trim()).length() > 2) {
            boolean isQuoted;
            char firstChar = result.charAt(0);
            char lastChar = result.charAt(result.length() - 1);
            boolean bl = isQuoted = firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
            if (isQuoted) {
                result = result.substring(1, result.length() - 1);
            }
        }
        return result;
    }

    private void createShell() {
        this.shell = new Shell(this.parent, 67616);
        this.shell.setText(this.getText());
        this.shell.addShellListener(new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                FontDialog.this.handleShellClose();
            }
        });
    }

    private void layoutAndCenterShell() {
        Point prefSize = this.shell.computeSize(-1, -1);
        prefSize.y += 50;
        this.shell.setSize(prefSize);
        Rectangle parentSize = this.parent.getBounds();
        int locationX = (parentSize.width - prefSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - prefSize.y) / 2 + parentSize.y;
        this.shell.setLocation(locationX, locationY);
    }

    private void createControls() {
        GridLayout mainLayout = new GridLayout(2, true);
        mainLayout.marginWidth = 10;
        mainLayout.marginHeight = 10;
        mainLayout.horizontalSpacing = 10;
        mainLayout.verticalSpacing = 10;
        this.shell.setLayout(mainLayout);
        this.createLeftArea(this.shell);
        this.createRightArea(this.shell);
        this.createPreviewArea(this.shell);
        this.createButtonArea(this.shell);
        this.fillAvailableFonts();
    }

    private void createLeftArea(Composite parent) {
        Composite leftArea = FontDialog.createVerticalArea(parent);
        this.createFontFamilyGroup(leftArea);
    }

    private void createRightArea(Composite parent) {
        Composite rightArea = FontDialog.createVerticalArea(parent);
        this.createFontSizeGroup(rightArea);
        this.createFontStyleGroup(rightArea);
        this.createFontColorGroup(rightArea);
    }

    private static Composite createVerticalArea(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout(layout);
        return result;
    }

    private void createFontFamilyGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, true));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontFamilyTitle"));
        result.setLayout(new GridLayout());
        this.txtFontFamily = new Text(result, 2048);
        GridData textData = new GridData(4, 0x1000000, true, false);
        this.txtFontFamily.setLayoutData(textData);
        this.lstFontFamily = new List(result, 2564);
        GridData listData = new GridData(4, 4, true, true);
        this.lstFontFamily.setLayoutData(listData);
        this.lstFontFamily.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int selectionIndex = FontDialog.this.lstFontFamily.getSelectionIndex();
                if (selectionIndex != -1) {
                    FontDialog.this.txtFontFamily.setText(FontDialog.this.lstFontFamily.getItem(selectionIndex));
                }
            }
        });
    }

    private void createFontSizeGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, false));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontSizeTitle"));
        result.setLayout(new GridLayout());
        this.spFontSize = new Spinner(result, 2048);
        this.spFontSize.setDigits(0);
        this.spFontSize.setMinimum(0);
        this.spFontSize.setMaximum(200);
        GridData spinnerData = new GridData(4, 4, true, true);
        this.spFontSize.setLayoutData(spinnerData);
    }

    private void createFontStyleGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, true));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontStyleTitle"));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout(layout);
        this.cbBold = new Button(result, 32);
        this.cbBold.setText(RWTMessages.getMessage("RWT_FontDialogFontStyleBold"));
        FontData normalFont = this.cbBold.getFont().getFontData()[0];
        Font boldFont = Graphics.getFont(normalFont.getName(), normalFont.getHeight(), 1);
        this.cbBold.setFont(boldFont);
        this.cbItalic = new Button(result, 32);
        this.cbItalic.setText(RWTMessages.getMessage("RWT_FontDialogFontStyleItalic"));
        Font italicFont = Graphics.getFont(normalFont.getName(), normalFont.getHeight(), 2);
        this.cbItalic.setFont(italicFont);
    }

    private void createFontColorGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, false));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontColorTitle"));
        result.setLayout(new GridLayout(2, false));
        this.lblColor = new Label(result, 2048);
        this.lblColor.setLayoutData(new GridData(20, 20));
        Button changeColorButton = new Button(result, 8);
        changeColorButton.setText(RWTMessages.getMessage("RWT_FontDialogFontColorSelect"));
        changeColorButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog.this.openColorDialog();
            }
        });
    }

    private void openColorDialog() {
        ColorDialog dialog = new ColorDialog(this.shell);
        dialog.setRGB(this.rgb);
        RGB selected = dialog.open();
        if (selected != null) {
            this.rgb = selected;
            this.updateControls();
        }
    }

    private void addChangeListeners() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog.this.updateFontData();
            }
        };
        this.spFontSize.addSelectionListener(selectionListener);
        this.cbBold.addSelectionListener(selectionListener);
        this.cbItalic.addSelectionListener(selectionListener);
        this.txtFontFamily.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = FontDialog.this.txtFontFamily.getText();
                FontDialog.this.selectFontFamilyInList(text);
                FontDialog.this.updateFontData();
            }
        });
    }

    private void createPreviewArea(Composite parent) {
        Composite previewArea = new Composite(parent, 2048);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.minimumWidth = 300;
        previewArea.setLayoutData(gridData);
        previewArea.setLayout(new GridLayout());
        this.lblPreview = new Label(previewArea, 0x1000000);
        GridData labelData = new GridData(4, 0x1000000, true, true);
        this.lblPreview.setLayoutData(labelData);
        this.lblPreview.setText(RWTMessages.getMessage("RWT_FontDialogPreviewText"));
        Display display = parent.getDisplay();
        Color bgColor = display.getSystemColor(25);
        previewArea.setBackground(bgColor);
        previewArea.setBackgroundMode(1);
    }

    private void createButtonArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(131072, 0x1000000, false, false, 2, 1);
        composite.setLayoutData(layoutData);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout(layout);
        Button okButton = this.createButton(composite, SWT.getMessage("SWT_OK"), 32);
        okButton.getShell().setDefaultButton(okButton);
        okButton.forceFocus();
        this.createButton(composite, SWT.getMessage("SWT_Cancel"), 256);
    }

    private Button createButton(Composite parent, String text, final int returnCode) {
        Button result = new Button(parent, 8);
        result.setText(text);
        GridData data = new GridData(256);
        int widthHint = FontDialog.convertHorizontalDLUsToPixels(result, 60);
        Point minSize = result.computeSize(-1, -1);
        data.widthHint = Math.max(widthHint, minSize.x);
        result.setLayoutData(data);
        result.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog.this.returnCode = returnCode;
                FontDialog.this.shell.close();
            }
        });
        return result;
    }

    private void handleShellClose() {
        if (this.returnCode != 32) {
            this.fontData = null;
            this.rgb = null;
        }
    }

    private void fillAvailableFonts() {
        HashSet<String> fontFamilies = new HashSet<String>();
        FontData[] fontList = this.parent.getDisplay().getFontList(null, true);
        if (fontList != null) {
            int i = 0;
            while (i < fontList.length) {
                fontFamilies.add(fontList[i].getName());
                ++i;
            }
        }
        Object[] availableFontNames = fontFamilies.toArray(new String[fontFamilies.size()]);
        Arrays.sort(availableFontNames);
        this.lstFontFamily.setItems((String[])availableFontNames);
    }

    private void updateControls() {
        String fontName = this.fontData.getName();
        if (!this.txtFontFamily.getText().equals(fontName)) {
            this.txtFontFamily.setText(fontName);
        }
        this.selectFontFamilyInList(fontName);
        this.spFontSize.setSelection(this.fontData.getHeight());
        this.cbBold.setSelection((this.fontData.getStyle() & 1) != 0);
        this.cbItalic.setSelection((this.fontData.getStyle() & 2) != 0);
        this.updatePreview();
    }

    private void selectFontFamilyInList(String fontFamily) {
        this.lstFontFamily.deselectAll();
        String[] items = this.lstFontFamily.getItems();
        int i = 0;
        while (i < items.length) {
            String item = items[i].toLowerCase(Locale.ENGLISH);
            if (fontFamily.toLowerCase(Locale.ENGLISH).equals(item)) {
                this.lstFontFamily.select(i);
            }
            ++i;
        }
    }

    private void updatePreview() {
        if (this.lblPreview != null) {
            Font font = Graphics.getFont(this.fontData);
            this.lblPreview.setFont(font);
            Color color = Graphics.getColor(this.rgb);
            this.lblPreview.setForeground(color);
            this.lblColor.setBackground(color);
            this.lblPreview.getParent().layout(true);
        }
    }

    private void updateFontData() {
        String name = this.fontData.getName();
        if (this.txtFontFamily.getText().length() > 0) {
            name = this.txtFontFamily.getText();
        }
        int height = this.spFontSize.getSelection();
        int style = 0;
        if (this.cbBold.getSelection()) {
            style |= 1;
        }
        if (this.cbItalic.getSelection()) {
            style |= 2;
        }
        this.fontData = new FontData(name, height, style);
        this.updateControls();
    }
}

