/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobLogHelper;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingJob.class);
    static final String INTERNAL_PROP_PREFIX = "gyrex.job.";
    public static final String PROP_JOB_ID = "gyrex.job.id";
    public static final String PROP_JOB_TYPE_ID = "gyrex.job.type";
    public static final String PROP_JOB_CONTEXT_PATH = "gyrex.job.contextPath";
    public static final String PROP_SCHEDULE_ID = "gyrex.job.scheduleId";
    public static final String PROP_SCHEDULE_ENTRY_ID = "gyrex.job.scheduleEntryId";
    public static final String PROP_ENABLED = "gyrex.job.enabled";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Boolean enabled;
        JobDataMap dataMap = context.getMergedJobDataMap();
        String jobId = dataMap.getString(PROP_JOB_ID);
        String jobTypeId = dataMap.getString(PROP_JOB_TYPE_ID);
        String jobContextPath = dataMap.getString(PROP_JOB_CONTEXT_PATH);
        String scheduleId = dataMap.getString(PROP_SCHEDULE_ID);
        String scheduleEntryId = dataMap.getString(PROP_SCHEDULE_ENTRY_ID);
        Boolean bl = enabled = dataMap.containsKey((Object)PROP_ENABLED) ? Boolean.valueOf(dataMap.getBooleanValue(PROP_ENABLED)) : null;
        if (enabled != null && !enabled.booleanValue()) {
            LOG.debug(String.format("Skipping execution of job '%s' - entry is not enabled", jobId));
            return;
        }
        try {
            Path contextPath = new Path(jobContextPath);
            JobLogHelper.setupMdc(jobId, (IPath)contextPath);
            HashMap<String, String> parameter = new HashMap<String, String>();
            for (Object keyObj : dataMap.keySet()) {
                Object value;
                String key;
                if (!(keyObj instanceof String) || StringUtils.startsWith((String)(key = (String)keyObj), (String)INTERNAL_PROP_PREFIX) || !((value = dataMap.get((Object)key)) instanceof String)) continue;
                parameter.put(key, (String)value);
            }
            IRuntimeContext runtimeContext = ((IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)contextPath);
            if (runtimeContext == null) {
                LOG.error("Unable to find context (using path {}) for job {}.", (Object)jobContextPath, (Object)jobId);
                return;
            }
            IJobManager jobManager = (IJobManager)runtimeContext.get(IJobManager.class);
            if (!(jobManager instanceof JobManagerImpl)) {
                LOG.error("Invalid job manager ({}). Please verify the system is setup properly.", (Object)jobManager);
                return;
            }
            JobManagerImpl jobManagerImpl = (JobManagerImpl)jobManager;
            IJob job = jobManagerImpl.getJob(jobId);
            if (job == null) {
                job = jobManagerImpl.createJob(jobTypeId, jobId, parameter);
            }
            if (((JobImpl)job).getState() != JobState.NONE && !jobManagerImpl.isStuck((JobImpl)job)) {
                LOG.warn("Job {} (type {}) cannot be queued because it is already active in the system (current state {}).", new Object[]{((JobImpl)job).getId(), ((JobImpl)job).getTypeId(), ((JobImpl)job).getState()});
                return;
            }
            try {
                IQueueService queueService = JobsActivator.getInstance().getQueueService();
                IQueue queue = queueService.getQueue("gyrex.jobs.queue.default", null);
                if (queue == null) {
                    queue = queueService.createQueue("gyrex.jobs.queue.default", null);
                }
                jobManager.queueJob(jobId, parameter, queue.getId(), String.format("Schedule '%s' entry '%s'.", scheduleId, scheduleEntryId));
            }
            catch (Exception e) {
                throw new JobExecutionException(String.format("Error queuing job '%s'. %s", jobId, e.getMessage()), (Throwable)e);
            }
        }
        finally {
            JobLogHelper.clearMdc();
        }
    }
}

