/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackConfigContentProvider;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackUiImages;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggerAppenderRef;
import org.eclipse.gyrex.logback.config.internal.model.Appender;
import org.eclipse.gyrex.logback.config.internal.model.ConsoleAppender;
import org.eclipse.gyrex.logback.config.internal.model.FileAppender;
import org.eclipse.gyrex.logback.config.internal.model.LogbackConfig;
import org.eclipse.gyrex.logback.config.internal.model.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LogbackLabelProvider
extends LabelProvider {
    private LocalResourceManager manager;

    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = this.getImageDescriptor(element);
        if (descriptor != null) {
            return this.getResourceManager().createImage(descriptor);
        }
        return super.getImage(element);
    }

    private ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof ConsoleAppender) {
            return LogbackUiImages.getImageDescriptor("console.gif");
        }
        if (element instanceof Appender) {
            Appender appender = (Appender)element;
            if (appender.canSift() && appender.isSeparateLogOutputsPerMdcProperty()) {
                return LogbackUiImages.getImageDescriptor("hierarchical.gif");
            }
            return LogbackUiImages.getImageDescriptor("flat.gif");
        }
        if (element instanceof Logger) {
            return LogbackUiImages.getImageDescriptor("category.gif");
        }
        if (element instanceof LogbackConfigContentProvider.DefaultLogger) {
            return null;
        }
        return null;
    }

    private ResourceManager getResourceManager() {
        if (this.manager == null) {
            this.manager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.manager;
    }

    public String getText(Object element) {
        if (element instanceof LogbackConfig) {
            return "Loback Configuration";
        }
        if (element instanceof FileAppender) {
            FileAppender fileAppender = (FileAppender)element;
            StrBuilder text = new StrBuilder();
            text.append(fileAppender.getName());
            text.append(String.format(" (-> %s)", fileAppender.getFileName()));
            if (fileAppender.getThreshold() != null) {
                text.append(String.format(" [%s]", fileAppender.getThreshold()));
            }
            if (fileAppender.isSeparateLogOutputsPerMdcProperty()) {
                text.append(String.format(" [mdc:%s]", fileAppender.getSiftingMdcPropertyName()));
            }
            return text.toString();
        }
        if (element instanceof Appender) {
            return ((Appender)element).getName();
        }
        if (element instanceof Logger) {
            Logger logger = (Logger)element;
            StrBuilder text = new StrBuilder();
            text.append(logger.getName()).append(": ");
            text.append((Object)logger.getLevel());
            if (!logger.isInheritOtherAppenders()) {
                text.append(" (not inheriting other appenders)");
            }
            return text.toString();
        }
        if (element instanceof LogbackConfigContentProvider.DefaultLogger) {
            return String.format("Default Level: %s", ((LogbackConfigContentProvider.DefaultLogger)element).getLevel());
        }
        if (element instanceof LoggerAppenderRef) {
            return ((LoggerAppenderRef)element).getAppenderRef();
        }
        return String.valueOf(element);
    }
}

