/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DialogField {
    private Label fLabel = null;
    protected String fLabelText = "";
    private IDialogFieldListener fDialogFieldListener;
    private boolean fEnabled = true;

    public static Control createEmptySpace(Composite parent) {
        return DialogField.createEmptySpace(parent, 1);
    }

    public static Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    public void adaptToForm(FormToolkit toolkit) {
    }

    protected final void assertCompositeNotNull(Composite comp) {
        Assert.isNotNull((Object)comp, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int nColumns) {
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }

    public void dialogFieldChanged() {
        if (this.fDialogFieldListener != null) {
            this.fDialogFieldListener.dialogFieldChanged(this);
        }
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DialogField.gridDataForLabel(nColumns));
        return new Control[]{label};
    }

    public Label getLabelControl(Composite parent) {
        if (this.fLabel == null) {
            this.assertCompositeNotNull(parent);
            this.fLabel = new Label(parent, 16448);
            this.fLabel.setFont(parent.getFont());
            this.fLabel.setEnabled(this.fEnabled);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                this.fLabel.setText(this.fLabelText);
            } else {
                this.fLabel.setText(".");
                this.fLabel.setVisible(false);
            }
        }
        return this.fLabel;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public final boolean isEnabled() {
        return this.fEnabled;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    public void postSetFocusOnDialogField(Display display) {
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DialogField.this.setFocus();
                }
            });
        }
    }

    public void refresh() {
        this.updateEnableState();
    }

    public final void setDialogFieldListener(IDialogFieldListener listener) {
        this.fDialogFieldListener = listener;
    }

    public final void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            this.updateEnableState();
        }
    }

    public boolean setFocus() {
        return false;
    }

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
        if (this.isOkToUse((Control)this.fLabel)) {
            this.fLabel.setText(labeltext);
        }
    }

    protected void updateEnableState() {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(this.fEnabled);
        }
    }
}

