/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.equinoxhttpservice.internal;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.monitoring.diagnostics.IStatusConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HttpServiceActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.http.equinoxhttpservice";
    private static final String PROP_JETTY_AUTOSTART = "org.eclipse.equinox.http.jetty.autostart";
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public HttpServiceActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        HttpServiceActivator.context = context;
        String autostart = context.getProperty(PROP_JETTY_AUTOSTART);
        if (autostart == null || !Boolean.FALSE.toString().equals(autostart)) {
            context.getBundles();
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getSymbolicName().equals("org.eclipse.equinox.http.jetty")) {
                    Status status = new Status(4, SYMBOLIC_NAME, MessageFormat.format("The Jetty-based HTTP service is configured to startup automatically. However, this is discouraged in Gyrex. Please set the system property ''{0}'' to ''{1}''. Usually, the property is set in the config.ini before startup.", PROP_JETTY_AUTOSTART, Boolean.FALSE.toString()));
                    this.getServiceHelper().registerService(IStatusConstants.SERVICE_NAME, (Object)status, "Eclipse Gyrex", "Jetty Auto-Start Error", SYMBOLIC_NAME.concat(".status.jettyautostart"), null);
                    break;
                }
                ++n2;
            }
        }
    }

    protected void doStop(BundleContext context) throws Exception {
        HttpServiceActivator.context = null;
    }
}

