/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.context.internal.AddContextDialog;
import org.eclipse.gyrex.admin.ui.context.internal.ContextUiLabelProvider;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class ContextsSection
extends ViewerWithButtonsSectionPart {
    private final ConfigurationPage page;
    private Button addButton;
    private Button removeButton;
    private ListViewer contextsList;
    protected IViewerObservableValue selectedValue;

    public ContextsSection(Composite parent, ConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.page = page;
        Section section = this.getSection();
        section.setText("Available Contexts");
        section.setDescription("Define the available contexts.");
        this.createContent(section);
    }

    void addButtonPressed() {
        AddContextDialog dialog = new AddContextDialog(SwtUtil.getShell((Widget)this.addButton), this.getContextRegistry());
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextsSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextsSection.this.removeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.contextsList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.contextsList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.contextsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contextsList.setLabelProvider((IBaseLabelProvider)new ContextUiLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.contextsList);
    }

    private DataBindingContext getBindingContext() {
        return this.page.getBindingContext();
    }

    private ContextRegistryImpl getContextRegistry() {
        return ContextActivator.getInstance().getContextRegistryImpl();
    }

    private ContextDefinition getSelectedContext() {
        return (ContextDefinition)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.contextsList;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.contextsList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        this.contextsList.setInput((Object)this.getContextRegistry().getDefinedContexts());
        super.refresh();
    }

    void removeButtonPressed() {
        ContextDefinition contextDefinition = this.getSelectedContext();
        if (contextDefinition == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Context", (String)"Do you really want to delete the context?")) {
            return;
        }
        this.getContextRegistry().removeDefinition(contextDefinition);
        this.markStale();
    }
}

