/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import java.util.ArrayList;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceData
implements IPropertySource {
    private static final String PREFIX_CHILD = "child__";
    private static final String PREFIX_KEY = "key__";
    private final IPropertyDescriptor[] descriptors;
    private final Preferences root;
    private final String path;

    public PreferenceData(Preferences root, String path) throws BackingStoreException {
        this.root = root;
        this.path = path;
        if (root.nodeExists(path)) {
            String[] childrenNames;
            String[] names;
            ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
            String[] stringArray = names = root.node(path).keys();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                descriptors.add(new PropertyDescriptor((Object)(PREFIX_KEY + name), name));
                ++n2;
            }
            String[] stringArray2 = childrenNames = root.node(path).childrenNames();
            int n3 = childrenNames.length;
            n = 0;
            while (n < n3) {
                String name = stringArray2[n];
                descriptors.add(new PropertyDescriptor((Object)(PREFIX_CHILD + name), name));
                ++n;
            }
            this.descriptors = descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
        } else {
            this.descriptors = new IPropertyDescriptor[0];
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        String name = id.toString();
        if (name.startsWith(PREFIX_CHILD)) {
            String childPath = String.valueOf(this.path) + "/" + name.substring(PREFIX_CHILD.length());
            try {
                return new PreferenceData(this.root, childPath);
            }
            catch (BackingStoreException e) {
                return ExceptionUtils.getRootCauseMessage((Throwable)e);
            }
        }
        if (name.startsWith(PREFIX_KEY)) {
            return this.root.node(this.path).get(name.substring(PREFIX_KEY.length()), "");
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

