/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.httpservice;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gyrex.http.application.context.IResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class DefaultResourceProvider
implements IResourceProvider {
    private final Bundle bundle;
    private final HttpContext context;

    public DefaultResourceProvider(Bundle bundle, HttpContext context) {
        this.bundle = bundle;
        this.context = context;
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        if (this.context != null) {
            return this.context.getResource(path);
        }
        return this.bundle.getEntry(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        Enumeration entryPaths = this.bundle.getEntryPaths(path);
        if (entryPaths == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            result.add((String)entryPaths.nextElement());
        }
        return result;
    }
}

