/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.Writer;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;

public class ClobLocatorWriter
extends Writer {
    private final Connection connection;
    private final Clob clob;
    private long currentPos;
    private boolean isClosed = false;

    public ClobLocatorWriter(Connection connection, Clob clob, long pos) throws SqlException {
        if (pos - 1L > clob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.connection = connection;
        this.clob = clob;
        this.currentPos = pos;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("This operation is not permitted because theWriter has been closed");
        }
    }

    public void write(int c) throws IOException {
        char[] ca = new char[]{(char)c};
        this.writeCharacters(ca, 0, ca.length);
    }

    public void write(char[] c) throws IOException {
        this.checkClosed();
        this.writeCharacters(c, 0, c.length);
    }

    public void flush() {
    }

    public void write(char[] c, int off, int len) throws IOException {
        this.checkClosed();
        if (len == 0) {
            return;
        }
        if (off < 0 || off > c.length || len < 0 || len > c.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.writeCharacters(c, off, len);
    }

    private void writeCharacters(char[] c, int off, int len) throws IOException {
        try {
            this.clob.setStringX(this.currentPos, new String(c, off, len), 0, len);
            this.currentPos += (long)len;
        }
        catch (SqlException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

