/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.transaction.xa.XAException;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.jdbc.ClientBaseDataSource;

public class LogWriter {
    protected PrintWriter printWriter_;
    protected int traceLevel_;
    private boolean driverConfigurationHasBeenWrittenToJdbc1Stream_ = false;
    private boolean driverConfigurationHasBeenWrittenToJdbc2Stream_ = false;
    public boolean printWriterNeedsToBeClosed_;

    public LogWriter(PrintWriter printWriter, int traceLevel) {
        this.printWriter_ = printWriter;
        this.traceLevel_ = traceLevel;
    }

    protected final boolean loggingEnabled(int traceLevel) {
        return this.printWriter_ != null && (traceLevel & this.traceLevel_) != 0;
    }

    protected final boolean traceSuspended() {
        return Configuration.traceSuspended__;
    }

    void close() {
        if (this.printWriterNeedsToBeClosed_) {
            this.printWriter_.close();
            this.printWriterNeedsToBeClosed_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dncprintln(String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprintln(String header, String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby]" + header + " " + s);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncprint(String header, String s) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby]" + header + " " + s);
            this.printWriter_.flush();
        }
    }

    public void tracepoint(String component, int tracepoint, String message) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprintln(component, "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + tracepoint + "]" + message);
    }

    public void tracepoint(String component, int tracepoint, String classContext, String methodContext) {
        if (this.traceSuspended()) {
            return;
        }
        String staticContextTracepointRecord = component + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + tracepoint + "]" + "[" + classContext + "." + methodContext + "]";
        this.dncprintln(staticContextTracepointRecord);
    }

    public void tracepoint(String component, int tracepoint, Object instance, String classContext, String methodContext) {
        if (this.traceSuspended()) {
            return;
        }
        String instanceContextTracepointRecord = component + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + tracepoint + "]" + "[" + classContext + "@" + Integer.toHexString(instance.hashCode()) + "." + methodContext + "]";
        this.dncprintln(instanceContextTracepointRecord);
    }

    public void tracepoint(String component, int tracepoint, String classContext, String methodContext, Map memory) {
        if (this.traceSuspended()) {
            return;
        }
        String staticContextTracepointRecord = component + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + tracepoint + "]" + "[" + classContext + "." + methodContext + "]";
        this.dncprintln(staticContextTracepointRecord + this.getMemoryMapDisplay(memory));
    }

    public void tracepoint(String component, int tracepoint, Object instance, String classContext, String methodContext, Map memory) {
        if (this.traceSuspended()) {
            return;
        }
        String instanceContextTracepointRecord = component + "[time:" + System.currentTimeMillis() + "]" + "[thread:" + Thread.currentThread().getName() + "]" + "[tracepoint:" + tracepoint + "]" + "[" + classContext + "@" + Integer.toHexString(instance.hashCode()) + "." + methodContext + "]";
        this.dncprintln(instanceContextTracepointRecord + this.getMemoryMapDisplay(memory));
    }

    private String getMemoryMapDisplay(Map memory) {
        return memory.toString();
    }

    private void traceExternalMethod(Object instance, String className, String methodName) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprint(this.buildExternalMethodHeader(instance, className), methodName);
    }

    private void traceExternalDeprecatedMethod(Object instance, String className, String methodName) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprint(this.buildExternalMethodHeader(instance, className), "Deprecated " + methodName);
    }

    private String buildExternalMethodHeader(Object instance, String className) {
        return "[Time:" + System.currentTimeMillis() + "]" + "[Thread:" + Thread.currentThread().getName() + "]" + "[" + className + "@" + Integer.toHexString(instance.hashCode()) + "]";
    }

    private String getClassNameOfInstanceIfTraced(Object instance) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof Connection && this.loggingEnabled(1)) {
            return "Connection";
        }
        if (instance instanceof ResultSet && this.loggingEnabled(4)) {
            return "ResultSet";
        }
        if (instance instanceof CallableStatement && this.loggingEnabled(2)) {
            return "CallableStatement";
        }
        if (instance instanceof PreparedStatement && this.loggingEnabled(2)) {
            return "PreparedStatement";
        }
        if (instance instanceof Statement && this.loggingEnabled(2)) {
            return "Statement";
        }
        if (instance instanceof Blob && this.loggingEnabled(-1)) {
            return "Blob";
        }
        if (instance instanceof Clob && this.loggingEnabled(-1)) {
            return "Clob";
        }
        if (instance instanceof DatabaseMetaData && this.loggingEnabled(-1)) {
            return "DatabaseMetaData";
        }
        if (this.loggingEnabled(2048) && instance.getClass().getName().startsWith("org.apache.derby.client.net.NetXAResource")) {
            return "NetXAResource";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.client.ClientPooledConnection")) {
            return "ClientPooledConnection";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.jdbc.ClientConnectionPoolDataSource")) {
            return "ClientConnectionPoolDataSource";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.client.ClientXAConnection")) {
            return "ClientXAConnection";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.jdbc.ClientDataSource")) {
            return "ClientDataSource";
        }
        if (this.loggingEnabled(-1) && instance.getClass().getName().equals("org.apache.derby.jdbc.ClientXADataSource")) {
            return "ClientXADataSource";
        }
        return instance.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceExit(Object instance, String methodName, Object returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalMethod(instance, className, methodName);
            this.printWriter_.println(" () returned " + returnValue);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDeprecatedExit(Object instance, String methodName, Object returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalDeprecatedMethod(instance, className, methodName);
            this.printWriter_.println(" () returned " + returnValue);
            this.printWriter_.flush();
        }
    }

    public void traceExit(Object instance, String methodName, ResultSet resultSet) {
        if (this.traceSuspended()) {
            return;
        }
        String returnValue = resultSet == null ? "ResultSet@null" : "ResultSet@" + Integer.toHexString(resultSet.hashCode());
        this.traceExit(instance, methodName, returnValue);
    }

    public void traceExit(Object instance, String methodName, CallableStatement returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "CallableStatement@" + Integer.toHexString(returnValue.hashCode()));
    }

    public void traceExit(Object instance, String methodName, PreparedStatement returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "PreparedStatement@" + Integer.toHexString(returnValue.hashCode()));
    }

    public void traceExit(Object instance, String methodName, Statement returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "Statement@" + Integer.toHexString(returnValue.hashCode()));
    }

    public void traceExit(Object instance, String methodName, Blob blob) {
        if (this.traceSuspended()) {
            return;
        }
        String returnValue = blob == null ? "Blob@null" : "Blob@" + Integer.toHexString(blob.hashCode());
        this.traceExit(instance, methodName, returnValue);
    }

    public void traceExit(Object instance, String methodName, Clob clob) {
        if (this.traceSuspended()) {
            return;
        }
        String returnValue = clob == null ? "Clob@null" : "Clob@" + Integer.toHexString(clob.hashCode());
        this.traceExit(instance, methodName, returnValue);
    }

    public void traceExit(Object instance, String methodName, DatabaseMetaData returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "DatabaseMetaData@" + Integer.toHexString(returnValue.hashCode()));
    }

    public void traceExit(Object instance, String methodName, Connection returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "Connection@" + Integer.toHexString(returnValue.hashCode()));
    }

    public void traceExit(Object instance, String methodName, ColumnMetaData returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "MetaData@" + (returnValue != null ? Integer.toHexString(returnValue.hashCode()) : null));
    }

    public void traceExit(Object instance, String methodName, byte[] returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, Utils.getStringFromBytes(returnValue));
    }

    public void traceExit(Object instance, String methodName, int[] returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, Utils.getStringFromInts(returnValue));
    }

    public void traceDeprecatedExit(Object instance, String methodName, byte[] returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedExit(instance, methodName, Utils.getStringFromBytes(returnValue));
    }

    public void traceExit(Object instance, String methodName, byte returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, "0x" + Integer.toHexString(returnValue & 0xFF));
    }

    public void traceExit(Object instance, String methodName, int returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, String.valueOf(returnValue));
    }

    public void traceExit(Object instance, String methodName, boolean returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, String.valueOf(returnValue));
    }

    public void traceExit(Object instance, String methodName, long returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, String.valueOf(returnValue));
    }

    public void traceExit(Object instance, String methodName, float returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, String.valueOf(returnValue));
    }

    public void traceExit(Object instance, String methodName, double returnValue) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceExit(instance, methodName, String.valueOf(returnValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceEntryAllArgs(Object instance, String methodName, String argList) {
        if (this.traceSuspended()) {
            return;
        }
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalMethod(instance, className, methodName);
            this.printWriter_.println(" " + argList + " called");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDeprecatedEntryAllArgs(Object instance, String methodName, String argList) {
        if (this.traceSuspended()) {
            return;
        }
        String className = this.getClassNameOfInstanceIfTraced(instance);
        if (className == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.traceExternalDeprecatedMethod(instance, className, methodName);
            this.printWriter_.println(" " + argList + " called");
            this.printWriter_.flush();
        }
    }

    public void traceEntry(Object instance, String methodName) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "()");
    }

    public void traceEntry(Object instance, String methodName, Object argument) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + argument + ")");
    }

    public void traceEntry(Object instance, String methodName, boolean argument) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + argument + ")");
    }

    public void traceEntry(Object instance, String methodName, int argument) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + argument + ")");
    }

    public void traceDeprecatedEntry(Object instance, String methodName, int argument) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(instance, methodName, "(" + argument + ")");
    }

    public void traceDeprecatedEntry(Object instance, String methodName, Object argument) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(instance, methodName, "(" + argument + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, Object arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, byte[] arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + Utils.getStringFromBytes(arg2) + ")");
    }

    public void traceDeprecatedEntry(Object instance, String methodName, int arg1, int arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceDeprecatedEntry(Object instance, String methodName, Object arg1, int arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceDeprecatedEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, boolean arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, byte arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", 0x" + Integer.toHexString(arg2 & 0xFF) + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, short arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, int arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, long arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, float arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, double arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, boolean arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, byte arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", 0x" + Integer.toHexString(arg2 & 0xFF) + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, short arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, int arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, long arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, float arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, double arg2) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, Object arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, Object arg2, Object arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, int arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, Object arg2, int arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceDeprecatedEntry(Object instance, String methodName, int arg1, Object arg2, int arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, int arg2, Object arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, int arg2, int arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, int arg2, int arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, int arg2, Object arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, boolean arg2, boolean arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, boolean arg2, int arg3) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, Object arg2, Object arg3, Object arg4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ")");
    }

    public void traceEntry(Object instance, String methodName, int arg1, Object arg2, int arg3, int arg4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, int arg2, int arg3, int arg4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, int arg3, int arg4) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, Object arg3, int arg4, boolean arg5) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ", " + arg5 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, Object arg3, boolean arg4, boolean arg5) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ", " + arg5 + ")");
    }

    public void traceEntry(Object instance, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntryAllArgs(instance, methodName, "(" + arg1 + ", " + arg2 + ", " + arg3 + ", " + arg4 + ", " + arg5 + ", " + arg6 + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(SqlException e) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(e, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(SQLException e) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(e, this.printWriter_, "[derby]", true);
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceDiagnosable(XAException e) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(512)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_DIAGNOSTICS");
            ExceptionFormatter.printTrace(e, this.printWriter_, "[derby]");
            this.dncprintln("END TRACE_DIAGNOSTICS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceParameterMetaData(Statement statement, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(256) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[ParameterMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_PARAMETER_META_DATA");
                this.dncprintln(header, "Parameter meta data for statement Statement@" + Integer.toHexString(statement.hashCode()));
                this.dncprintln(header, "Number of parameter columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(header, columnMetaData);
                this.dncprintln(header, "END TRACE_PARAMETER_META_DATA");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace parameter meta data");
                this.dncprintln(header, "END TRACE_PARAMETER_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceResultSetMetaData(Statement statement, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        if (!this.loggingEnabled(128) || columnMetaData == null) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[ResultSetMetaData@" + Integer.toHexString(columnMetaData.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_RESULT_SET_META_DATA");
                this.dncprintln(header, "Result set meta data for statement Statement@" + Integer.toHexString(statement.hashCode()));
                this.dncprintln(header, "Number of result set columns: " + columnMetaData.getColumnCount());
                this.traceColumnMetaData(header, columnMetaData);
                this.dncprintln(header, "END TRACE_RESULT_SET_META_DATA");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace result set meta data");
                this.dncprintln(header, "END TRACE_RESULT_SET_META_DATA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceColumnMetaData(String header, ColumnMetaData columnMetaData) {
        if (this.traceSuspended()) {
            return;
        }
        try {
            PrintWriter printWriter = this.printWriter_;
            synchronized (printWriter) {
                for (int column = 1; column <= columnMetaData.getColumnCount(); ++column) {
                    this.dncprint(header, "Column " + column + ": { ");
                    this.printWriter_.print("label=" + columnMetaData.getColumnLabel(column) + ", ");
                    this.printWriter_.print("name=" + columnMetaData.getColumnName(column) + ", ");
                    this.printWriter_.print("type name=" + columnMetaData.getColumnTypeName(column) + ", ");
                    this.printWriter_.print("type=" + columnMetaData.getColumnType(column) + ", ");
                    this.printWriter_.print("nullable=" + columnMetaData.isNullable(column) + ", ");
                    this.printWriter_.print("precision=" + columnMetaData.getPrecision(column) + ", ");
                    this.printWriter_.print("scale=" + columnMetaData.getScale(column) + ", ");
                    this.printWriter_.print("schema name=" + columnMetaData.getSchemaName(column) + ", ");
                    this.printWriter_.print("table name=" + columnMetaData.getTableName(column) + ", ");
                    this.printWriter_.print("writable=" + columnMetaData.isWritable(column) + ", ");
                    this.printWriter_.print("sqlPrecision=" + (columnMetaData.sqlPrecision_ == null ? "<null>" : "" + columnMetaData.sqlPrecision_[column - 1]) + ", ");
                    this.printWriter_.print("sqlScale=" + (columnMetaData.sqlScale_ == null ? "<null>" : "" + columnMetaData.sqlScale_[column - 1]) + ", ");
                    this.printWriter_.print("sqlLength=" + (columnMetaData.sqlLength_ == null ? "<null>" : "" + columnMetaData.sqlLength_[column - 1]) + ", ");
                    this.printWriter_.print("sqlType=" + (columnMetaData.sqlType_ == null ? "<null>" : "" + columnMetaData.sqlType_[column - 1]) + ", ");
                    this.printWriter_.print("sqlCcsid=" + (columnMetaData.sqlCcsid_ == null ? "<null>" : "" + columnMetaData.sqlCcsid_[column - 1]) + ", ");
                    this.printWriter_.print("sqlName=" + (columnMetaData.sqlName_ == null ? "<null>" : columnMetaData.sqlName_[column - 1]) + ", ");
                    this.printWriter_.print("sqlLabel=" + (columnMetaData.sqlLabel_ == null ? "<null>" : columnMetaData.sqlLabel_[column - 1]) + ", ");
                    this.printWriter_.print("sqlUnnamed=" + (columnMetaData.sqlUnnamed_ == null ? "<null>" : "" + columnMetaData.sqlUnnamed_[column - 1]) + ", ");
                    this.printWriter_.print("sqlComment=" + (columnMetaData.sqlComment_ == null ? "<null>" : columnMetaData.sqlComment_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxKeymem=" + (columnMetaData.sqlxKeymem_ == null ? "<null>" : "" + columnMetaData.sqlxKeymem_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxGenerated=" + (columnMetaData.sqlxGenerated_ == null ? "<null>" : "" + columnMetaData.sqlxGenerated_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxParmmode=" + (columnMetaData.sqlxParmmode_ == null ? "<null>" : "" + columnMetaData.sqlxParmmode_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxCorname=" + (columnMetaData.sqlxCorname_ == null ? "<null>" : columnMetaData.sqlxCorname_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxName=" + (columnMetaData.sqlxName_ == null ? "<null>" : columnMetaData.sqlxName_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxBasename=" + (columnMetaData.sqlxBasename_ == null ? "<null>" : columnMetaData.sqlxBasename_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxUpdatable=" + (columnMetaData.sqlxUpdatable_ == null ? "<null>" : "" + columnMetaData.sqlxUpdatable_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxSchema=" + (columnMetaData.sqlxSchema_ == null ? "<null>" : columnMetaData.sqlxSchema_[column - 1]) + ", ");
                    this.printWriter_.print("sqlxRdbnam=" + (columnMetaData.sqlxRdbnam_ == null ? "<null>" : columnMetaData.sqlxRdbnam_[column - 1]) + ", ");
                    this.printWriter_.print("internal type=" + columnMetaData.types_[column - 1] + ", ");
                    this.printWriter_.println(" }");
                }
                this.dncprint(header, "{ ");
                this.printWriter_.print("sqldHold=" + columnMetaData.sqldHold_ + ", ");
                this.printWriter_.print("sqldReturn=" + columnMetaData.sqldReturn_ + ", ");
                this.printWriter_.print("sqldScroll=" + columnMetaData.sqldScroll_ + ", ");
                this.printWriter_.print("sqldSensitive=" + columnMetaData.sqldSensitive_ + ", ");
                this.printWriter_.print("sqldFcode=" + columnMetaData.sqldFcode_ + ", ");
                this.printWriter_.print("sqldKeytype=" + columnMetaData.sqldKeytype_ + ", ");
                this.printWriter_.print("sqldRdbnam=" + columnMetaData.sqldRdbnam_ + ", ");
                this.printWriter_.print("sqldSchema=" + columnMetaData.sqldSchema_);
                this.printWriter_.println(" }");
                this.printWriter_.flush();
            }
        }
        catch (SQLException e) {
            this.dncprintln(header, "Encountered an SQL exception while trying to trace column meta data");
        }
    }

    public void traceConnectEntry(ClientBaseDataSource dataSource) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc2();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(dataSource);
        }
    }

    public void traceConnectEntry(String server, int port, String database, Properties properties) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(16)) {
            this.traceDriverConfigurationJdbc1();
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsEntry(server, port, database, properties);
        }
    }

    public void traceConnectResetEntry(Object instance, LogWriter logWriter, String user, ClientBaseDataSource ds) {
        if (this.traceSuspended()) {
            return;
        }
        this.traceEntry(instance, "reset", (Object)logWriter, (Object)user, (Object)"<escaped>", (Object)ds);
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetEntry(ds);
        }
    }

    public void traceConnectExit(Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsExit(connection);
        }
    }

    public void traceConnectResetExit(Connection connection) {
        if (this.traceSuspended()) {
            return;
        }
        if (this.loggingEnabled(32)) {
            this.traceConnectsResetExit(connection);
        }
    }

    private void traceConnectsResetEntry(ClientBaseDataSource dataSource) {
        try {
            if (this.traceSuspended()) {
                return;
            }
            this.traceConnectsResetEntry(dataSource.getServerName(), dataSource.getPortNumber(), dataSource.getDatabaseName(), this.getProperties(dataSource));
        }
        catch (SqlException se) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection reset entry");
        }
    }

    private void traceConnectsEntry(ClientBaseDataSource dataSource) {
        try {
            if (this.traceSuspended()) {
                return;
            }
            this.traceConnectsEntry(dataSource.getServerName(), dataSource.getPortNumber(), dataSource.getDatabaseName(), this.getProperties(dataSource));
        }
        catch (SqlException se) {
            this.dncprintln("Encountered an SQL exception while trying to trace connection entry");
        }
    }

    private void traceConnectsResetEntry(String server, int port, String database, Properties properties) {
        if (this.traceSuspended()) {
            return;
        }
        this.dncprintln("BEGIN TRACE_CONNECT_RESET");
        this.dncprintln("Connection reset requested for " + server + ":" + port + "/" + database);
        this.dncprint("Using properties: ");
        this.writeProperties(properties);
        this.dncprintln("END TRACE_CONNECT_RESET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceConnectsEntry(String server, int port, String database, Properties properties) {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.dncprintln("BEGIN TRACE_CONNECTS");
            this.dncprintln("Attempting connection to " + server + ":" + port + "/" + database);
            this.dncprint("Using properties: ");
            this.writeProperties(properties);
            this.dncprintln("END TRACE_CONNECTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsExit(Connection c) {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[Connection@" + Integer.toHexString(c.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_CONNECTS");
                this.dncprintln(header, "Successfully connected to server " + c.databaseMetaData_.getURL());
                this.dncprintln(header, "User: " + c.databaseMetaData_.getUserName());
                this.dncprintln(header, "Database product name: " + c.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(header, "Database product version: " + c.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(header, "Driver name: " + c.databaseMetaData_.getDriverName());
                this.dncprintln(header, "Driver version: " + c.databaseMetaData_.getDriverVersion());
                this.dncprintln(header, "END TRACE_CONNECTS");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace connection exit");
                this.dncprintln(header, "END TRACE_CONNECTS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceConnectsResetExit(Connection c) {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            String header = "[Connection@" + Integer.toHexString(c.hashCode()) + "]";
            try {
                this.dncprintln(header, "BEGIN TRACE_CONNECT_RESET");
                this.dncprintln(header, "Successfully reset connection to server " + c.databaseMetaData_.getURL());
                this.dncprintln(header, "User: " + c.databaseMetaData_.getUserName());
                this.dncprintln(header, "Database product name: " + c.databaseMetaData_.getDatabaseProductName());
                this.dncprintln(header, "Database product version: " + c.databaseMetaData_.getDatabaseProductVersion());
                this.dncprintln(header, "Driver name: " + c.databaseMetaData_.getDriverName());
                this.dncprintln(header, "Driver version: " + c.databaseMetaData_.getDriverVersion());
                this.dncprintln(header, "END TRACE_CONNECT_RESET");
            }
            catch (SQLException e) {
                this.dncprintln(header, "Encountered an SQL exception while trying to trace connection reset exit");
                this.dncprintln(header, "END TRACE_CONNECT_RESET");
            }
        }
    }

    private void writeProperties(Properties properties) {
        this.printWriter_.print("{ ");
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            if ("password".equals(e.getKey())) {
                this.printWriter_.print("password=" + this.escapePassword((String)e.getValue()));
            } else {
                this.printWriter_.print(e.getKey() + "=" + e.getValue());
            }
            if (!i.hasNext()) continue;
            this.printWriter_.print(", ");
        }
        this.printWriter_.println(" }");
        this.printWriter_.flush();
    }

    private String escapePassword(String pw) {
        StringBuffer sb = new StringBuffer(pw);
        for (int j = 0; j < pw.length(); ++j) {
            sb.setCharAt(j, '*');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc2() {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc2Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc2Stream_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDriverConfigurationJdbc1() {
        if (this.traceSuspended()) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            if (!this.driverConfigurationHasBeenWrittenToJdbc1Stream_) {
                this.writeDriverConfiguration();
                this.driverConfigurationHasBeenWrittenToJdbc1Stream_ = true;
            }
        }
    }

    public void writeDriverConfiguration() {
        Version.writeDriverConfiguration(this.printWriter_);
    }

    public static PrintWriter getPrintWriter(final String fileName, final boolean fileAppend) throws SqlException {
        PrintWriter printWriter = null;
        try {
            printWriter = (PrintWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String fileCanonicalPath = new File(fileName).getCanonicalPath();
                    return new PrintWriter(new BufferedOutputStream(new FileOutputStream(fileCanonicalPath, fileAppend), 4096), true);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new SqlException(null, new ClientMessageId("XJ113.S"), new Object[]{fileName, pae.getMessage()}, (Throwable)pae);
        }
        return printWriter;
    }

    private Properties getProperties(ClientBaseDataSource cds) throws SqlException {
        Properties properties = new Properties();
        try {
            Reference ref = cds.getReference();
            Enumeration<RefAddr> e = ref.getAll();
            while (e.hasMoreElements()) {
                RefAddr attribute = e.nextElement();
                String propertyKey = attribute.getType();
                String value = (String)attribute.getContent();
                if ("password".equals(propertyKey)) {
                    value = "********";
                }
                if (value == null) continue;
                properties.setProperty(propertyKey, value);
            }
        }
        catch (NamingException e) {
            throw new SqlException(this, new ClientMessageId("XJ001.U"), (Object)e.getClass().getName(), (Object)e.getMessage(), (Throwable)e);
        }
        return properties;
    }
}

