/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.ConnectionReply;
import org.apache.derby.client.net.ConnectionRequestInterface;
import org.apache.derby.client.net.EbcdicCcsidManager;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetConnectionReply;
import org.apache.derby.client.net.NetConnectionRequest;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetPackageReply;
import org.apache.derby.client.net.NetPackageRequest;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetStatementReply;
import org.apache.derby.client.net.NetStatementRequest;
import org.apache.derby.client.net.NetXAConnectionReply;
import org.apache.derby.client.net.NetXAConnectionRequest;
import org.apache.derby.client.net.OpenSocketAction;
import org.apache.derby.client.net.Reply;
import org.apache.derby.client.net.Request;
import org.apache.derby.client.net.ResultSetReply;
import org.apache.derby.client.net.ResultSetRequestInterface;
import org.apache.derby.client.net.StatementReply;
import org.apache.derby.client.net.StatementRequestInterface;
import org.apache.derby.client.net.Typdef;

public class NetAgent
extends Agent {
    public ConnectionRequestInterface connectionRequest_;
    public NetConnectionRequest packageRequest_;
    public StatementRequestInterface statementRequest_;
    public ResultSetRequestInterface resultSetRequest_;
    public ConnectionReply connectionReply_;
    public ConnectionReply packageReply_;
    public StatementReply statementReply_;
    public ResultSetReply resultSetReply_;
    NetConnection netConnection_;
    protected Request request_;
    public NetConnectionRequest netConnectionRequest_;
    public NetPackageRequest netPackageRequest_;
    public NetStatementRequest netStatementRequest_;
    public NetResultSetRequest netResultSetRequest_;
    protected Reply reply_;
    public NetConnectionReply netConnectionReply_;
    public NetPackageReply netPackageReply_;
    public NetStatementReply netStatementReply_;
    public NetResultSetReply netResultSetReply_;
    Socket socket_;
    InputStream rawSocketInputStream_;
    OutputStream rawSocketOutputStream_;
    String server_;
    int port_;
    int clientSSLMode_;
    public CcsidManager sourceCcsidManager_;
    public CcsidManager targetCcsidManager_;
    public Typdef typdef_;
    public Typdef targetTypdef_;
    public Typdef originalTargetTypdef_;
    protected int svrcod_;
    public int orignalTargetSqlam_;
    public int targetSqlam_;
    public SqlException exceptionOpeningSocket_;
    public SqlException exceptionConvertingRdbnam;

    public NetAgent(NetConnection netConnection, LogWriter logWriter) throws SqlException {
        super(netConnection, logWriter);
        this.targetSqlam_ = this.orignalTargetSqlam_ = 7;
        this.exceptionOpeningSocket_ = null;
        this.exceptionConvertingRdbnam = null;
        this.netConnection_ = netConnection;
    }

    NetAgent(NetConnection netConnection, LogWriter netLogWriter, int loginTimeout, String server, int port, int clientSSLMode) throws SqlException {
        super(netConnection, netLogWriter);
        this.targetSqlam_ = this.orignalTargetSqlam_ = 7;
        this.exceptionOpeningSocket_ = null;
        this.exceptionConvertingRdbnam = null;
        this.server_ = server;
        this.port_ = port;
        this.netConnection_ = netConnection;
        this.clientSSLMode_ = clientSSLMode;
        if (this.server_ == null) {
            throw new DisconnectException((Agent)this, new ClientMessageId("08001.C.1"), (Object)"serverName");
        }
        try {
            this.socket_ = (Socket)AccessController.doPrivileged(new OpenSocketAction(server, port, this.clientSSLMode_));
        }
        catch (PrivilegedActionException e) {
            throw new DisconnectException((Agent)this, new ClientMessageId("08001.C.2"), new Object[]{e.getException().getClass().getName(), server, Integer.toString(port), e.getException().getMessage()}, (Throwable)e.getException());
        }
        try {
            if (this.exceptionOpeningSocket_ == null) {
                this.socket_.setTcpNoDelay(true);
                this.socket_.setKeepAlive(true);
                this.socket_.setSoTimeout(loginTimeout * 1000);
            }
        }
        catch (SocketException e) {
            try {
                this.socket_.close();
            }
            catch (IOException doNothing) {
                // empty catch block
            }
            this.exceptionOpeningSocket_ = new DisconnectException((Agent)this, new ClientMessageId("08001.C.3"), (Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.exceptionOpeningSocket_ == null) {
                this.rawSocketOutputStream_ = this.socket_.getOutputStream();
                this.rawSocketInputStream_ = this.socket_.getInputStream();
            }
        }
        catch (IOException e) {
            try {
                this.socket_.close();
            }
            catch (IOException doNothing) {
                // empty catch block
            }
            this.exceptionOpeningSocket_ = new DisconnectException((Agent)this, new ClientMessageId("08001.C.4"), (Object)e.getMessage(), (Throwable)e);
        }
        this.targetCcsidManager_ = this.sourceCcsidManager_ = new EbcdicCcsidManager();
        if (this.netConnection_.isXAConnection()) {
            NetXAConnectionReply netXAConnectionReply_ = new NetXAConnectionReply(this, this.netConnection_.commBufferSize_);
            this.netResultSetReply_ = netXAConnectionReply_;
            this.netStatementReply_ = this.netResultSetReply_;
            this.netPackageReply_ = this.netStatementReply_;
            this.netConnectionReply_ = this.netPackageReply_;
            this.reply_ = this.netConnectionReply_;
            this.resultSetReply_ = new ResultSetReply(this, this.netResultSetReply_, this.netStatementReply_, this.netConnectionReply_);
            this.statementReply_ = this.resultSetReply_;
            this.connectionReply_ = this.packageReply_ = this.statementReply_;
            NetXAConnectionRequest netXAConnectionRequest_ = new NetXAConnectionRequest(this, this.sourceCcsidManager_, this.netConnection_.commBufferSize_);
            this.netResultSetRequest_ = netXAConnectionRequest_;
            this.netStatementRequest_ = this.netResultSetRequest_;
            this.netPackageRequest_ = this.netStatementRequest_;
            this.netConnectionRequest_ = this.netPackageRequest_;
            this.request_ = this.netConnectionRequest_;
            this.resultSetRequest_ = this.netResultSetRequest_;
            this.statementRequest_ = this.netStatementRequest_;
            this.packageRequest_ = this.netPackageRequest_;
            this.connectionRequest_ = this.netConnectionRequest_;
        } else {
            this.netResultSetReply_ = new NetResultSetReply(this, this.netConnection_.commBufferSize_);
            this.netStatementReply_ = this.netResultSetReply_;
            this.netPackageReply_ = this.netStatementReply_;
            this.netConnectionReply_ = this.netPackageReply_;
            this.reply_ = this.netConnectionReply_;
            this.resultSetReply_ = new ResultSetReply(this, this.netResultSetReply_, this.netStatementReply_, this.netConnectionReply_);
            this.statementReply_ = this.resultSetReply_;
            this.connectionReply_ = this.packageReply_ = this.statementReply_;
            this.netResultSetRequest_ = new NetResultSetRequest(this, this.sourceCcsidManager_, this.netConnection_.commBufferSize_);
            this.netStatementRequest_ = this.netResultSetRequest_;
            this.netPackageRequest_ = this.netStatementRequest_;
            this.netConnectionRequest_ = this.netPackageRequest_;
            this.request_ = this.netConnectionRequest_;
            this.resultSetRequest_ = this.netResultSetRequest_;
            this.statementRequest_ = this.netStatementRequest_;
            this.packageRequest_ = this.netPackageRequest_;
            this.connectionRequest_ = this.netConnectionRequest_;
        }
    }

    protected void resetAgent_(LogWriter netLogWriter, int loginTimeout, String server, int port) throws SqlException {
        this.exceptionConvertingRdbnam = null;
        this.targetTypdef_ = this.originalTargetTypdef_;
        this.svrcod_ = 0;
        try {
            this.socket_.setSoTimeout(loginTimeout * 1000);
        }
        catch (SocketException e) {
            try {
                this.socket_.close();
            }
            catch (IOException doNothing) {
                // empty catch block
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("08006.C.2"), (Object)e.getMessage(), (Throwable)e);
        }
    }

    void setSvrcod(int svrcod) {
        if (svrcod > this.svrcod_) {
            this.svrcod_ = svrcod;
        }
    }

    void clearSvrcod() {
        this.svrcod_ = CodePoint.SVRCOD_INFO;
    }

    int getSvrcod() {
        return this.svrcod_;
    }

    public void flush_() throws DisconnectException {
        this.sendRequest();
        this.reply_.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close_() throws SqlException {
        SqlException latestException;
        SqlException accumulatedExceptions = null;
        if (this.rawSocketInputStream_ != null) {
            try {
                this.rawSocketInputStream_.close();
            }
            catch (IOException e) {
                accumulatedExceptions = new SqlException(this.logWriter_, new ClientMessageId("08006.C.3"), (Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.rawSocketInputStream_ = null;
            }
        }
        if (this.rawSocketOutputStream_ != null) {
            try {
                this.rawSocketOutputStream_.close();
            }
            catch (IOException e) {
                latestException = new SqlException(this.logWriter_, new ClientMessageId("08006.C.3"), (Object)e.getMessage(), (Throwable)e);
                accumulatedExceptions = Utils.accumulateSQLException(latestException, accumulatedExceptions);
            }
            finally {
                this.rawSocketOutputStream_ = null;
            }
        }
        if (this.socket_ != null) {
            try {
                this.socket_.close();
            }
            catch (IOException e) {
                latestException = new SqlException(this.logWriter_, new ClientMessageId("08006.C.3"), (Object)e.getMessage(), (Throwable)e);
                accumulatedExceptions = Utils.accumulateSQLException(latestException, accumulatedExceptions);
            }
            finally {
                this.socket_ = null;
            }
        }
        if (accumulatedExceptions != null) {
            throw accumulatedExceptions;
        }
    }

    protected void setTimeout(int timeout) {
        try {
            this.socket_.setSoTimeout(timeout * 1000);
        }
        catch (SocketException se) {
            System.out.println("NetAgent.setTimeout: ignoring exception: " + se);
        }
    }

    protected int getTimeout() {
        int timeout = 0;
        try {
            timeout = this.socket_.getSoTimeout();
        }
        catch (SocketException se) {
            System.out.println("NetAgent.getTimeout: ignoring exception: " + se);
        }
        return timeout /= 1000;
    }

    protected void sendRequest() throws DisconnectException {
        try {
            this.request_.flush(this.rawSocketOutputStream_);
        }
        catch (IOException e) {
            this.throwCommunicationsFailure(e);
        }
    }

    public InputStream getInputStream() {
        return this.rawSocketInputStream_;
    }

    public OutputStream getOutputStream() {
        return this.rawSocketOutputStream_;
    }

    void setInputStream(InputStream inputStream) {
        this.rawSocketInputStream_ = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.rawSocketOutputStream_ = outputStream;
    }

    public void throwCommunicationsFailure(Throwable cause) throws DisconnectException {
        this.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this, new ClientMessageId("08006.C.3"), (Object)cause.getMessage(), cause));
    }

    public LogWriter newLogWriter_(PrintWriter printWriter, int traceLevel) {
        return new NetLogWriter(printWriter, traceLevel);
    }

    protected void markChainBreakingException_() {
        this.setSvrcod(CodePoint.SVRCOD_ERROR);
    }

    public void checkForChainBreakingException_() throws SqlException {
        int svrcod = this.getSvrcod();
        this.clearSvrcod();
        if (svrcod > CodePoint.SVRCOD_WARNING) {
            super.checkForExceptions();
        }
    }

    private void writeDeferredResetConnection() throws SqlException {
        if (!this.netConnection_.resetConnectionAtFirstSql_) {
            return;
        }
        try {
            this.netConnection_.writeDeferredReset();
        }
        catch (SqlException sqle) {
            DisconnectException de = new DisconnectException((Agent)this, new ClientMessageId("08006.C.4"));
            de.setNextException(sqle);
            throw de;
        }
    }

    public void beginWriteChainOutsideUOW() throws SqlException {
        this.request_.initialize();
        this.writeDeferredResetConnection();
        super.beginWriteChainOutsideUOW();
    }

    public void beginWriteChain(Statement statement) throws SqlException {
        this.request_.initialize();
        this.writeDeferredResetConnection();
        super.beginWriteChain(statement);
    }

    protected void endWriteChain() {
        super.endWriteChain();
    }

    private void readDeferredResetConnection() throws SqlException {
        if (!this.netConnection_.resetConnectionAtFirstSql_) {
            return;
        }
        try {
            this.netConnection_.readDeferredReset();
            this.checkForExceptions();
        }
        catch (SqlException sqle) {
            DisconnectException de = new DisconnectException((Agent)this, new ClientMessageId("08006.C.4"));
            de.setNextException(sqle);
            throw de;
        }
    }

    protected void beginReadChain(Statement statement) throws SqlException {
        this.readDeferredResetConnection();
        super.beginReadChain(statement);
    }

    protected void beginReadChainOutsideUOW() throws SqlException {
        this.readDeferredResetConnection();
        super.beginReadChainOutsideUOW();
    }

    public void endReadChain() throws SqlException {
        super.endReadChain();
    }

    public String convertToStringTcpIpAddress(int tcpIpAddress) {
        StringBuffer ipAddrBytes = new StringBuffer();
        ipAddrBytes.append(tcpIpAddress >> 24 & 0xFF);
        ipAddrBytes.append(".");
        ipAddrBytes.append(tcpIpAddress >> 16 & 0xFF);
        ipAddrBytes.append(".");
        ipAddrBytes.append(tcpIpAddress >> 8 & 0xFF);
        ipAddrBytes.append(".");
        ipAddrBytes.append(tcpIpAddress & 0xFF);
        return ipAddrBytes.toString();
    }

    protected int getPort() {
        return this.port_;
    }
}

